/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.chameleon.render.helpers;

import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.render.helpers.ModularBoxRenderer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PanelBoxRenderer {
    public static final int FACE_YNEG = 0;
    public static final int FACE_YPOS = 1;
    public static final int FACE_ZNEG = 2;
    public static final int FACE_ZPOS = 3;
    public static final int FACE_XNEG = 4;
    public static final int FACE_XPOS = 5;
    private static final int TRIM_CUT = 63;
    private ChamRender renderer;
    private ModularBoxRenderer trimRenderer;
    private double trimWidth = 0.0625;
    private double trimDepth = 0.0;
    private float[] trimColor = new float[3];
    private TextureAtlasSprite trimIcon;
    private float[] panelColor = new float[3];
    private TextureAtlasSprite panelIcon;

    public PanelBoxRenderer(ChamRender renderer) {
        this.renderer = renderer;
        this.trimRenderer = new ModularBoxRenderer(renderer);
    }

    public void setTrimWidth(double width) {
        this.trimWidth = width;
    }

    public void setTrimDepth(double depth) {
        this.trimDepth = depth;
    }

    public void setTrimIcon(TextureAtlasSprite icon) {
        this.trimIcon = icon;
    }

    public void setTrimColor(float[] color) {
        this.copyFrom(this.trimColor, color);
    }

    public void setPanelIcon(TextureAtlasSprite icon) {
        this.panelIcon = icon;
    }

    public void setPanelColor(float[] color) {
        this.copyFrom(this.panelColor, color);
    }

    public void renderFacePanel(EnumFacing face, IBlockAccess blockAccess, IBlockState state, BlockPos pos, double xNeg, double yNeg, double zNeg, double xPos, double yPos, double zPos) {
        switch (face.func_176745_a()) {
            case 0: {
                this.renderer.setRenderBounds(xNeg + this.trimWidth, yNeg + this.trimDepth, zNeg + this.trimWidth, xPos - this.trimWidth, yNeg + this.trimDepth, zPos - this.trimWidth);
                this.renderPanelFace(face, blockAccess, state, pos);
                break;
            }
            case 1: {
                this.renderer.setRenderBounds(xNeg + this.trimWidth, yPos - this.trimDepth, zNeg + this.trimWidth, xPos - this.trimWidth, yPos - this.trimDepth, zPos - this.trimWidth);
                this.renderPanelFace(face, blockAccess, state, pos);
                break;
            }
            case 2: {
                this.renderer.setRenderBounds(xNeg + this.trimWidth, yNeg + this.trimWidth, zNeg + this.trimDepth, xPos - this.trimWidth, yPos - this.trimWidth, zNeg + this.trimDepth);
                this.renderPanelFace(face, blockAccess, state, pos);
                break;
            }
            case 3: {
                this.renderer.setRenderBounds(xNeg + this.trimWidth, yNeg + this.trimWidth, zPos - this.trimDepth, xPos - this.trimWidth, yPos - this.trimWidth, zPos - this.trimDepth);
                this.renderPanelFace(face, blockAccess, state, pos);
                break;
            }
            case 4: {
                this.renderer.setRenderBounds(xNeg + this.trimDepth, yNeg + this.trimWidth, zNeg + this.trimWidth, xNeg + this.trimDepth, yPos - this.trimWidth, zPos - this.trimWidth);
                this.renderPanelFace(face, blockAccess, state, pos);
                break;
            }
            case 5: {
                this.renderer.setRenderBounds(xPos - this.trimDepth, yNeg + this.trimWidth, zNeg + this.trimWidth, xPos - this.trimDepth, yPos - this.trimWidth, zPos - this.trimWidth);
                this.renderPanelFace(face, blockAccess, state, pos);
            }
        }
    }

    public void renderInteriorTrim(EnumFacing face, IBlockAccess blockAccess, IBlockState state, BlockPos pos, double xNeg, double yNeg, double zNeg, double xPos, double yPos, double zPos) {
        switch (face.func_176745_a()) {
            case 0: {
                this.renderer.setRenderBounds(xNeg + this.trimWidth, yNeg, zPos - this.trimWidth, xPos - this.trimWidth, yNeg + this.trimDepth, zPos - this.trimWidth);
                this.renderCutFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg + this.trimWidth, yNeg, zNeg + this.trimWidth, xPos - this.trimWidth, yNeg + this.trimDepth, zNeg + this.trimWidth);
                this.renderCutFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - this.trimWidth, yNeg, zNeg + this.trimWidth, xPos - this.trimWidth, yNeg + this.trimDepth, zPos - this.trimWidth);
                this.renderCutFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg + this.trimWidth, yNeg, zNeg + this.trimWidth, xNeg + this.trimWidth, yNeg + this.trimDepth, zPos - this.trimWidth);
                this.renderCutFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
                break;
            }
            case 1: {
                this.renderer.setRenderBounds(xNeg + this.trimWidth, yPos - this.trimDepth, zPos - this.trimWidth, xPos - this.trimWidth, yPos, zPos - this.trimWidth);
                this.renderCutFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg + this.trimWidth, yPos - this.trimDepth, zNeg + this.trimWidth, xPos - this.trimWidth, yPos, zNeg + this.trimWidth);
                this.renderCutFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - this.trimWidth, yPos - this.trimDepth, zNeg + this.trimWidth, xPos - this.trimWidth, yPos, zPos - this.trimWidth);
                this.renderCutFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg + this.trimWidth, yPos - this.trimDepth, zNeg + this.trimWidth, xNeg + this.trimWidth, yPos, zPos - this.trimWidth);
                this.renderCutFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
                break;
            }
            case 2: {
                this.renderer.setRenderBounds(xNeg + this.trimWidth, yPos - this.trimWidth, zNeg, xPos - this.trimWidth, yPos - this.trimWidth, zNeg + this.trimDepth);
                this.renderCutFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg + this.trimWidth, yNeg + this.trimWidth, zNeg, xPos - this.trimWidth, yNeg + this.trimWidth, zNeg + this.trimDepth);
                this.renderCutFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - this.trimWidth, yNeg + this.trimWidth, zNeg, xPos - this.trimWidth, yPos - this.trimWidth, zNeg + this.trimDepth);
                this.renderCutFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg + this.trimWidth, yNeg + this.trimWidth, zNeg, xNeg + this.trimWidth, yPos - this.trimWidth, zNeg + this.trimDepth);
                this.renderCutFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
                break;
            }
            case 3: {
                this.renderer.setRenderBounds(xNeg + this.trimWidth, yPos - this.trimWidth, zPos - this.trimDepth, xPos - this.trimWidth, yPos - this.trimWidth, zPos);
                this.renderCutFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg + this.trimWidth, yNeg + this.trimWidth, zPos - this.trimDepth, xPos - this.trimWidth, yNeg + this.trimWidth, zPos);
                this.renderCutFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - this.trimWidth, yNeg + this.trimWidth, zPos - this.trimDepth, xPos - this.trimWidth, yPos - this.trimWidth, zPos);
                this.renderCutFace(ChamRender.FACE_XNEG, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg + this.trimWidth, yNeg + this.trimWidth, zPos - this.trimDepth, xNeg + this.trimWidth, yPos - this.trimWidth, zPos);
                this.renderCutFace(ChamRender.FACE_XPOS, blockAccess, state, pos);
                break;
            }
            case 4: {
                this.renderer.setRenderBounds(xNeg, yNeg + this.trimWidth, zPos - this.trimWidth, xNeg + this.trimDepth, yPos - this.trimWidth, zPos - this.trimWidth);
                this.renderCutFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg, yNeg + this.trimWidth, zNeg + this.trimWidth, xNeg + this.trimDepth, yPos - this.trimWidth, zNeg + this.trimWidth);
                this.renderCutFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg, yPos - this.trimWidth, zNeg + this.trimWidth, xNeg + this.trimDepth, yPos - this.trimWidth, zPos - this.trimWidth);
                this.renderCutFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg, yNeg + this.trimWidth, zNeg + this.trimWidth, xNeg + this.trimDepth, yNeg + this.trimWidth, zPos - this.trimWidth);
                this.renderCutFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
                break;
            }
            case 5: {
                this.renderer.setRenderBounds(xPos - this.trimDepth, yNeg + this.trimWidth, zPos - this.trimWidth, xPos, yPos - this.trimWidth, zPos - this.trimWidth);
                this.renderCutFace(ChamRender.FACE_ZNEG, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - this.trimDepth, yNeg + this.trimWidth, zNeg + this.trimWidth, xPos, yPos - this.trimWidth, zNeg + this.trimWidth);
                this.renderCutFace(ChamRender.FACE_ZPOS, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - this.trimDepth, yPos - this.trimWidth, zNeg + this.trimWidth, xPos, yPos - this.trimWidth, zPos - this.trimWidth);
                this.renderCutFace(ChamRender.FACE_YNEG, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - this.trimDepth, yNeg + this.trimWidth, zNeg + this.trimWidth, xPos, yNeg + this.trimWidth, zPos - this.trimWidth);
                this.renderCutFace(ChamRender.FACE_YPOS, blockAccess, state, pos);
            }
        }
    }

    public void renderFaceTrim(EnumFacing face, IBlockAccess blockAccess, IBlockState state, BlockPos pos, double xNeg, double yNeg, double zNeg, double xPos, double yPos, double zPos) {
        double unit = this.trimWidth;
        switch (face.func_176745_a()) {
            case 0: {
                this.renderer.setRenderBounds(xNeg, yNeg, zNeg, xNeg + unit, yNeg, zNeg + unit);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - unit, yNeg, zNeg, xPos, yNeg, zNeg + unit);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg, yNeg, zPos - unit, xNeg + unit, yNeg, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - unit, yNeg, zPos - unit, xPos, yNeg, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg + unit, yNeg, zNeg, xPos - unit, yNeg, zNeg + unit);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg + unit, yNeg, zPos - unit, xPos - unit, yNeg, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg, yNeg, zNeg + unit, xNeg + unit, yNeg, zPos - unit);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - unit, yNeg, zNeg + unit, xPos, yNeg, zPos - unit);
                this.renderCutFace(face, blockAccess, state, pos);
                break;
            }
            case 1: {
                this.renderer.setRenderBounds(xNeg, yPos, zNeg, xNeg + unit, yPos, zNeg + unit);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - unit, yPos, zNeg, xPos, yPos, zNeg + unit);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg, yPos, zPos - unit, xNeg + unit, yPos, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - unit, yPos, zPos - unit, xPos, yPos, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg + unit, yPos, zNeg, xPos - unit, yPos, zNeg + unit);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg + unit, yPos, zPos - unit, xPos - unit, yPos, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg, yPos, zNeg + unit, xNeg + unit, yPos, zPos - unit);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - unit, yPos, zNeg + unit, xPos, yPos, zPos - unit);
                this.renderCutFace(face, blockAccess, state, pos);
                break;
            }
            case 2: {
                this.renderer.setRenderBounds(xNeg, yNeg, zNeg, xNeg + unit, yNeg + unit, zNeg);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - unit, yNeg, zNeg, xPos, yNeg + unit, zNeg);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg, yPos - unit, zNeg, xNeg + unit, yPos, zNeg);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - unit, yPos - unit, zNeg, xPos, yPos, zNeg);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg + unit, yNeg, zNeg, xPos - unit, yNeg + unit, zNeg);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg + unit, yPos - unit, zNeg, xPos - unit, yPos, zNeg);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg, yNeg + unit, zNeg, xNeg + unit, yPos - unit, zNeg);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - unit, yNeg + unit, zNeg, xPos, yPos - unit, zNeg);
                this.renderCutFace(face, blockAccess, state, pos);
                break;
            }
            case 3: {
                this.renderer.setRenderBounds(xNeg, yNeg, zPos, xNeg + unit, yNeg + unit, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - unit, yNeg, zPos, xPos, yNeg + unit, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg, yPos - unit, zPos, xNeg + unit, yPos, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - unit, yPos - unit, zPos, xPos, yPos, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg + unit, yNeg, zPos, xPos - unit, yNeg + unit, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg + unit, yPos - unit, zPos, xPos - unit, yPos, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg, yNeg + unit, zPos, xNeg + unit, yPos - unit, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos - unit, yNeg + unit, zPos, xPos, yPos - unit, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                break;
            }
            case 4: {
                this.renderer.setRenderBounds(xNeg, yNeg, zNeg, xNeg, yNeg + unit, zNeg + unit);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg, yPos - unit, zNeg, xNeg, yPos, zNeg + unit);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg, yNeg, zPos - unit, xNeg, yNeg + unit, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg, yPos - unit, zPos - unit, xNeg, yPos, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg, yNeg + unit, zNeg, xNeg, yPos - unit, zNeg + unit);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg, yNeg + unit, zPos - unit, xNeg, yPos - unit, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg, yNeg, zNeg + unit, xNeg, yNeg + unit, zPos - unit);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xNeg, yPos - unit, zNeg + unit, xNeg, yPos, zPos - unit);
                this.renderCutFace(face, blockAccess, state, pos);
                break;
            }
            case 5: {
                this.renderer.setRenderBounds(xPos, yNeg, zNeg, xPos, yNeg + unit, zNeg + unit);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos, yPos - unit, zNeg, xPos, yPos, zNeg + unit);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos, yNeg, zPos - unit, xPos, yNeg + unit, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos, yPos - unit, zPos - unit, xPos, yPos, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos, yNeg + unit, zNeg, xPos, yPos - unit, zNeg + unit);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos, yNeg + unit, zPos - unit, xPos, yPos - unit, zPos);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos, yNeg, zNeg + unit, xPos, yNeg + unit, zPos - unit);
                this.renderCutFace(face, blockAccess, state, pos);
                this.renderer.setRenderBounds(xPos, yPos - unit, zNeg + unit, xPos, yPos, zPos - unit);
                this.renderCutFace(face, blockAccess, state, pos);
            }
        }
    }

    private void renderCutFace(EnumFacing face, IBlockAccess blockAccess, IBlockState state, BlockPos pos) {
        this.renderer.renderFace(face, blockAccess, state, pos, this.trimIcon, this.trimColor[0], this.trimColor[1], this.trimColor[2]);
    }

    private void renderPanelFace(EnumFacing face, IBlockAccess blockAccess, IBlockState state, BlockPos pos) {
        this.renderer.renderFace(face, blockAccess, state, pos, this.panelIcon, this.panelColor[0], this.panelColor[1], this.panelColor[2]);
    }

    private void copyFrom(float[] target, float[] source) {
        target[0] = source[0];
        target[1] = source[1];
        target[2] = source[2];
    }

    private void copyFrom(float[] target, float r, float g, float b) {
        target[0] = r;
        target[1] = g;
        target[2] = b;
    }
}

