/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server;

import fossilsarcheology.Revival;
import fossilsarcheology.client.sound.FASoundRegistry;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.block.FAFluidRegistry;
import fossilsarcheology.server.block.IBlockItem;
import fossilsarcheology.server.block.ISlabItem;
import fossilsarcheology.server.block.entity.TileEntityAmphora;
import fossilsarcheology.server.block.entity.TileEntityAnalyzer;
import fossilsarcheology.server.block.entity.TileEntityAncientChest;
import fossilsarcheology.server.block.entity.TileEntityAnuStatue;
import fossilsarcheology.server.block.entity.TileEntityAnubiteStatue;
import fossilsarcheology.server.block.entity.TileEntityBubbleBlower;
import fossilsarcheology.server.block.entity.TileEntityCultivate;
import fossilsarcheology.server.block.entity.TileEntityFeeder;
import fossilsarcheology.server.block.entity.TileEntityFigurine;
import fossilsarcheology.server.block.entity.TileEntityKylix;
import fossilsarcheology.server.block.entity.TileEntitySarcophagus;
import fossilsarcheology.server.block.entity.TileEntitySifter;
import fossilsarcheology.server.block.entity.TileEntityTimeMachine;
import fossilsarcheology.server.block.entity.TileEntityVolute;
import fossilsarcheology.server.block.entity.TileEntityWorktable;
import fossilsarcheology.server.container.AnalyzerContainer;
import fossilsarcheology.server.container.CultivateContainer;
import fossilsarcheology.server.container.FeederContainer;
import fossilsarcheology.server.container.SifterContainer;
import fossilsarcheology.server.container.TimeMachineContainer;
import fossilsarcheology.server.container.WorktableContainer;
import fossilsarcheology.server.entity.EntityFishBase;
import fossilsarcheology.server.entity.FAEntityRegistry;
import fossilsarcheology.server.entity.FAVillagerRegistry;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoric;
import fossilsarcheology.server.entity.prehistoric.MobType;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.entity.projectile.EntityBirdEgg;
import fossilsarcheology.server.event.FossilBonemealEvent;
import fossilsarcheology.server.event.FossilCraftingEvent;
import fossilsarcheology.server.event.FossilPickupItemEvent;
import fossilsarcheology.server.item.FAItemRegistry;
import fossilsarcheology.server.item.enchantment.FAEnchantmentRegistry;
import fossilsarcheology.server.recipe.FAMachineRecipeRegistry;
import fossilsarcheology.server.recipe.FAOreDictRegistry;
import fossilsarcheology.server.recipe.RecipeTarDrops;
import fossilsarcheology.server.util.FossilFoodMappings;
import fossilsarcheology.server.world.FAWorldGenerator;
import fossilsarcheology.server.world.FAWorldRegistry;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class ServerProxy
implements IGuiHandler {
    public static final int GUI_ANALYZER = 0;
    public static final int GUI_CULTIVATE = 1;
    public static final int GUI_FEEDER = 2;
    public static final int GUI_WORKTABLE = 3;
    public static final int GUI_SIFTER = 4;
    public static final int GUI_TIME_MACHINE = 5;
    public static final int GUI_DINOPEDIA = 6;

    @SubscribeEvent
    public static void registerVillagers(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new VillagerRegistry.VillagerProfession[]{FAVillagerRegistry.ARCHEOLOGIST_PROFESSION, FAVillagerRegistry.PALAEONTOLOGIST_PROFESSION});
    }

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Enchantment[]{FAEnchantmentRegistry.ENCHANTMENT_ARCHEOLOGY, FAEnchantmentRegistry.ENCHANTMENT_PALEONTOLOGY});
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IRecipe recipeTarDrops = (IRecipe)new RecipeTarDrops().setRegistryName(new ResourceLocation("fossil:tar_drop_from_bucket"));
        event.getRegistry().registerAll((IForgeRegistryEntry[])new IRecipe[]{recipeTarDrops});
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        try {
            for (Field f : FABlockRegistry.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (obj instanceof Block) {
                    FABlockRegistry.registerBlock(event, (Block)obj);
                    continue;
                }
                if (!(obj instanceof Block[])) continue;
                for (Block block : (Block[])obj) {
                    FABlockRegistry.registerBlock(event, block);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        GameRegistry.registerTileEntity(TileEntityCultivate.class, (String)"fossil:cultivate");
        GameRegistry.registerTileEntity(TileEntityFeeder.class, (String)"fossil:feeder");
        GameRegistry.registerTileEntity(TileEntityBubbleBlower.class, (String)"fossil:bubble_blower");
        GameRegistry.registerTileEntity(TileEntityWorktable.class, (String)"fossil:archeology_workbench");
        GameRegistry.registerTileEntity(TileEntityAnalyzer.class, (String)"fossil:analyzer");
        GameRegistry.registerTileEntity(TileEntityAncientChest.class, (String)"fossil:ancient_chest");
        GameRegistry.registerTileEntity(TileEntityAnubiteStatue.class, (String)"fossil:anubite");
        GameRegistry.registerTileEntity(TileEntityAnuStatue.class, (String)"fossil:anu_statue");
        GameRegistry.registerTileEntity(TileEntityFigurine.class, (String)"fossil:figurine");
        GameRegistry.registerTileEntity(TileEntityKylix.class, (String)"fossil:kylix");
        GameRegistry.registerTileEntity(TileEntitySarcophagus.class, (String)"fossil:sarcophagus");
        GameRegistry.registerTileEntity(TileEntitySifter.class, (String)"fossil:sifter");
        GameRegistry.registerTileEntity(TileEntityAmphora.class, (String)"fossil:amphora");
        GameRegistry.registerTileEntity(TileEntityTimeMachine.class, (String)"fossil:time_machine");
        GameRegistry.registerTileEntity(TileEntityVolute.class, (String)"fossil:volute");
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Object obj;
        FAItemRegistry.COOKED_CHICKEN_SOUP.func_77642_a(Items.field_151133_ar);
        try {
            for (Field f : FAItemRegistry.class.getDeclaredFields()) {
                obj = f.get(null);
                if (obj instanceof Item) {
                    FAItemRegistry.registerItem(event, (Item)obj);
                    continue;
                }
                if (!(obj instanceof Item[])) continue;
                for (Item item : (Item[])obj) {
                    FAItemRegistry.registerItem(event, item);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        try {
            for (Field f : FABlockRegistry.class.getDeclaredFields()) {
                obj = f.get(null);
                if (obj instanceof Block) {
                    ServerProxy.registerItemBlocks((Block)obj, event);
                    continue;
                }
                if (!(obj instanceof Block[])) continue;
                for (Item item : (Block[])obj) {
                    ServerProxy.registerItemBlocks((Block)item, event);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        PrehistoricEntityType.register(event);
        FAMachineRecipeRegistry.init();
    }

    private static void registerItemBlocks(Block block, RegistryEvent.Register<Item> event) {
        if (block instanceof IBlockItem) {
            ItemBlock itemBlock = ((IBlockItem)block).getItemBlock(block);
            String name = itemBlock.func_77658_a().substring("item.".length());
            itemBlock.setRegistryName(new ResourceLocation("fossil", name));
            event.getRegistry().register((IForgeRegistryEntry)itemBlock);
        } else if (block instanceof ISlabItem) {
            ItemBlock itemBlock = ((ISlabItem)block).getItemBlock();
            String name = itemBlock.func_77658_a().substring("item.".length());
            itemBlock.setRegistryName(new ResourceLocation("fossil", name));
            event.getRegistry().register((IForgeRegistryEntry)itemBlock);
        } else {
            ItemBlock itemBlock = new ItemBlock(block);
            String name = itemBlock.func_77658_a().substring("item.".length());
            itemBlock.setRegistryName(new ResourceLocation("fossil", name));
            event.getRegistry().register((IForgeRegistryEntry)itemBlock);
        }
    }

    @SubscribeEvent
    public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        try {
            for (Field f : FASoundRegistry.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof SoundEvent)) continue;
                event.getRegistry().register((IForgeRegistryEntry)((SoundEvent)obj));
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public static void registerBiome(RegistryEvent.Register<Biome> event) {
        event.getRegistry().register(FAWorldRegistry.ANU_BIOME.setRegistryName("Lair of Darkness"));
        event.getRegistry().register(FAWorldRegistry.TREASURE_BIOME.setRegistryName("Treasure"));
        BiomeDictionary.addTypes((Biome)FAWorldRegistry.ANU_BIOME, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER, BiomeDictionary.Type.VOID});
        BiomeDictionary.addTypes((Biome)FAWorldRegistry.TREASURE_BIOME, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.VOID});
        if (Revival.CONFIG_OPTIONS.spawnVolcanoes) {
            event.getRegistry().register(FAWorldRegistry.VOLCANO_BIOME.setRegistryName("Volcano"));
            BiomeDictionary.addTypes((Biome)FAWorldRegistry.VOLCANO_BIOME, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY});
            BiomeManager.addSpawnBiome((Biome)FAWorldRegistry.VOLCANO_BIOME);
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(FAWorldRegistry.VOLCANO_BIOME, Revival.CONFIG_OPTIONS.volcanoSpawnChance));
        }
    }

    public void onPreInit() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Revival.INSTANCE, (IGuiHandler)this);
        FAFluidRegistry.register();
        FAEntityRegistry.register();
        FAWorldRegistry.register();
    }

    public void onInit() {
        FAOreDictRegistry.register();
        MinecraftForge.EVENT_BUS.register((Object)new FossilCraftingEvent());
        MinecraftForge.EVENT_BUS.register((Object)new FossilPickupItemEvent());
        MinecraftForge.EVENT_BUS.register((Object)new FossilBonemealEvent());
        GameRegistry.registerWorldGenerator((IWorldGenerator)new FAWorldGenerator(), (int)0);
    }

    public void calculateChainBuffer(EntityFishBase entity) {
    }

    public void calculateChainBuffer(EntityPrehistoric entity) {
    }

    public void onPostInit() {
        for (final PrehistoricEntityType prehistoric : PrehistoricEntityType.values()) {
            if (prehistoric.mobType != MobType.BIRD) continue;
            BlockDispenser.field_149943_a.func_82595_a((Object)prehistoric.birdEggItem, (Object)new BehaviorProjectileDispense(){

                protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                    EntityBirdEgg egg = new EntityBirdEgg(false, worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                    egg.setEnumType(prehistoric);
                    return egg;
                }
            });
            BlockDispenser.field_149943_a.func_82595_a((Object)prehistoric.bestBirdEggItem, (Object)new BehaviorProjectileDispense(){

                protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                    EntityBirdEgg egg = new EntityBirdEgg(true, worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                    egg.setEnumType(prehistoric);
                    return egg;
                }
            });
        }
        FossilFoodMappings.register();
        FAVillagerRegistry.register();
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity entity = world.func_175625_s(pos);
        if (id == 0 && entity instanceof TileEntityAnalyzer) {
            return new AnalyzerContainer(player.field_71071_by, (TileEntityAnalyzer)entity);
        }
        if (id == 1 && entity instanceof TileEntityCultivate) {
            return new CultivateContainer(player.field_71071_by, (TileEntityCultivate)entity);
        }
        if (id == 2 && entity instanceof TileEntityFeeder) {
            return new FeederContainer((IInventory)player.field_71071_by, (TileEntityFeeder)entity);
        }
        if (id == 3 && entity instanceof TileEntityWorktable) {
            return new WorktableContainer(player.field_71071_by, (TileEntityWorktable)entity);
        }
        if (id == 4 && entity instanceof TileEntitySifter) {
            return new SifterContainer(player.field_71071_by, (TileEntitySifter)entity);
        }
        if (id == 5 && entity instanceof TileEntityTimeMachine) {
            return new TimeMachineContainer(player.field_71071_by, (TileEntityTimeMachine)entity);
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public void spawnPacketItemParticles(World worldObj, float f, float f1, float f2, double motionX, double motionY, double motionZ, Item item) {
    }

    public void spawnPacketBlockParticles(World worldObj, float f, float f1, float f2, double motionX, double motionY, double motionZ, Block block) {
    }

    public void spawnPacketHeartParticles(World worldObj, float f, float f1, float f2, double motionX, double motionY, double motionZ) {
    }

    public void spawnBubbleParticles(World world, float f, float f1, float f2, double motionX, double motionY, double motionZ) {
    }

    public void spawnAnuParticle(World world, double posX, double posY, double posZ) {
    }

    public void spawnFAParticle(String type, float posX, float posY, float posZ, double motionX, double motionY, double motionZ) {
    }

    public void playSound(SoundEvent sound) {
    }

    public void stopSound(SoundEvent sound) {
    }

    public Object getArmorModel(int id) {
        return null;
    }

    public void openPedia() {
    }
}

