/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block;

import fossilsarcheology.server.api.DefaultRenderedItem;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.tab.FATabRegistry;
import fossilsarcheology.server.world.gen.WorldGenCalamites;
import fossilsarcheology.server.world.gen.WorldGenCordaites;
import fossilsarcheology.server.world.gen.WorldGenPalm;
import fossilsarcheology.server.world.gen.WorldGenSigillaria;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FossilSaplingBlock
extends BlockBush
implements DefaultRenderedItem,
IGrowable {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);

    public FossilSaplingBlock(String name) {
        this.func_149647_a(FATabRegistry.BLOCKS);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.2f);
        this.func_149752_b(1.0f);
        this.func_149663_c(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            super.func_180650_b(world, pos, state, rand);
            if (world.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.grow(world, pos, state, rand);
            }
        }
    }

    public void grow(World world, BlockPos pos, IBlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            world.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else if (this.canGenerateTree(world, pos)) {
            this.generateTree(world, pos, rand);
        }
    }

    public boolean canGenerateTree(World world, BlockPos pos) {
        if (this == FABlockRegistry.PALM_SAPLING) {
            return WorldGenPalm.canGenTree(world, pos);
        }
        if (this == FABlockRegistry.CALAMITES_SAPLING) {
            return WorldGenCalamites.canGenTree(world, pos);
        }
        if (this == FABlockRegistry.SIGILLARIA_SAPLING) {
            return WorldGenSigillaria.canGenTree(world, pos);
        }
        if (this == FABlockRegistry.CORDAITES_SAPLING) {
            return WorldGenCordaites.canGenTree(world, pos);
        }
        return false;
    }

    public void generateTree(World world, BlockPos pos, Random rand) {
        if (this == FABlockRegistry.PALM_SAPLING) {
            WorldGenPalm treeGen = new WorldGenPalm();
            world.func_175698_g(pos);
            treeGen.func_180709_b(world, rand, pos);
        }
        if (this == FABlockRegistry.CALAMITES_SAPLING) {
            WorldGenCalamites calamitesGen = new WorldGenCalamites();
            world.func_175698_g(pos);
            calamitesGen.func_180709_b(world, rand, pos);
        }
        if (this == FABlockRegistry.SIGILLARIA_SAPLING) {
            WorldGenSigillaria sigillaria = new WorldGenSigillaria();
            world.func_175698_g(pos);
            sigillaria.func_180709_b(world, rand, pos);
        }
        if (this == FABlockRegistry.CORDAITES_SAPLING) {
            WorldGenCordaites cordaites = new WorldGenCordaites();
            world.func_175698_g(pos);
            cordaites.func_180709_b(world, rand, pos);
        }
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return (double)world.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        this.grow(world, pos, state, rand);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }
}

