/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.entity.prehistoric;

import fossilsarcheology.client.sound.FASoundRegistry;
import fossilsarcheology.server.entity.ai.DinoAIEatFeedersAndBlocks;
import fossilsarcheology.server.entity.ai.DinoAIEatItems;
import fossilsarcheology.server.entity.ai.DinoAIFindWaterTarget;
import fossilsarcheology.server.entity.ai.DinoAIFollowOwner;
import fossilsarcheology.server.entity.ai.DinoAIGetInWater;
import fossilsarcheology.server.entity.ai.DinoAIHunt;
import fossilsarcheology.server.entity.ai.DinoAIHurtByTarget;
import fossilsarcheology.server.entity.ai.DinoAILookIdle;
import fossilsarcheology.server.entity.ai.DinoAIOwnerHurtByTarget;
import fossilsarcheology.server.entity.ai.DinoAIOwnerHurtTarget;
import fossilsarcheology.server.entity.ai.DinoAIRiding;
import fossilsarcheology.server.entity.ai.DinoAIWander;
import fossilsarcheology.server.entity.ai.DinoAIWatchClosest;
import fossilsarcheology.server.entity.ai.DinoMeleeAttackAI;
import fossilsarcheology.server.entity.prehistoric.EntityPrehistoricSwimming;
import fossilsarcheology.server.entity.prehistoric.EntitySarcosuchus;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityType;
import fossilsarcheology.server.entity.prehistoric.PrehistoricEntityTypeAI;
import fossilsarcheology.server.item.FAItemRegistry;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityMegalograptus
extends EntityPrehistoricSwimming {
    private static final DataParameter<Boolean> SWIMMING = EntityDataManager.func_187226_a(EntitySarcosuchus.class, (DataSerializer)DataSerializers.field_187198_h);
    public float swimProgress;
    private boolean isSwimming;

    public EntityMegalograptus(World world) {
        super(world, PrehistoricEntityType.MEGALOGRAPTUS, 1.0, 3.0, 5.0, 25.0, 0.25, 0.25, 4.0, 8.0);
        this.setActualSize(0.9f, 0.5f);
        this.isAmphibious = true;
        this.minSize = 0.2f;
        this.maxSize = 0.8f;
        this.teenAge = 3;
        this.hasBabyTexture = true;
        this.pediaScale = 30.0f;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return PrehistoricEntityType.BONELESS_LOOT;
    }

    public void func_70108_f(Entity entityIn) {
    }

    @Override
    public String getTexture() {
        String gender;
        String string = this.func_70631_g_() ? "_baby" : (gender = this.getGender() == 0 ? "_female" : "_male");
        if (this.isSkeleton()) {
            return "fossil:textures/model/" + this.type.toString().toLowerCase() + "_0/" + this.type.toString().toLowerCase() + "_skeleton.png";
        }
        return "fossil:textures/model/" + this.type.toString().toLowerCase() + "_0/" + this.type.toString().toLowerCase() + gender + ".png";
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new DinoAIFindWaterTarget((EntityCreature)this, 10, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DinoMeleeAttackAI(this, 1.0, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new DinoAIGetInWater(this, 1.0));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new DinoAIEatFeedersAndBlocks(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new DinoAIEatItems(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new DinoAIRiding(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DinoAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DinoAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new DinoAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new DinoAIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new DinoAIHurtByTarget(this));
        this.field_70715_bh.func_75776_a(4, new DinoAIHunt<EntityLivingBase>(this, EntityLivingBase.class, true, (Predicate<EntityLivingBase>)((com.google.common.base.Predicate)entity -> entity instanceof EntityLivingBase)));
        this.field_70699_by.func_189566_q().func_186316_c(true);
    }

    @Override
    public void setSpawnValues() {
    }

    @Override
    public PrehistoricEntityTypeAI.Activity aiActivityType() {
        return PrehistoricEntityTypeAI.Activity.DIURINAL;
    }

    @Override
    public PrehistoricEntityTypeAI.Attacking aiAttackType() {
        return PrehistoricEntityTypeAI.Attacking.BASIC;
    }

    @Override
    public PrehistoricEntityTypeAI.Climbing aiClimbType() {
        return PrehistoricEntityTypeAI.Climbing.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Following aiFollowType() {
        return PrehistoricEntityTypeAI.Following.AGRESSIVE;
    }

    @Override
    public PrehistoricEntityTypeAI.Jumping aiJumpType() {
        return PrehistoricEntityTypeAI.Jumping.BASIC;
    }

    @Override
    public PrehistoricEntityTypeAI.Response aiResponseType() {
        return PrehistoricEntityTypeAI.Response.AGRESSIVE;
    }

    @Override
    public PrehistoricEntityTypeAI.Stalking aiStalkType() {
        return PrehistoricEntityTypeAI.Stalking.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Taming aiTameType() {
        return PrehistoricEntityTypeAI.Taming.FEEDING;
    }

    @Override
    public PrehistoricEntityTypeAI.Untaming aiUntameType() {
        return PrehistoricEntityTypeAI.Untaming.NONE;
    }

    @Override
    public PrehistoricEntityTypeAI.Moving aiMovingType() {
        return PrehistoricEntityTypeAI.Moving.SEMIAQUATIC;
    }

    @Override
    public PrehistoricEntityTypeAI.WaterAbility aiWaterAbilityType() {
        return PrehistoricEntityTypeAI.WaterAbility.ATTACK;
    }

    @Override
    public boolean doesFlock() {
        return false;
    }

    @Override
    public Item getOrderItem() {
        return FAItemRegistry.SHELL;
    }

    @Override
    public int getAdultAge() {
        return 5;
    }

    @Override
    public int getMaxHunger() {
        return 50;
    }

    @Override
    public double swimSpeed() {
        return 0.5;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        boolean swimming = this.isSwimming();
        if (swimming && this.swimProgress < 20.0f) {
            this.swimProgress += 0.5f;
        } else if (!swimming && this.swimProgress > 0.0f) {
            this.swimProgress -= 0.5f;
        }
        if (this.isSwimming() && (this.func_70906_o() || this.isSleeping())) {
            this.func_70904_g(false);
            this.setSleeping(false);
        }
        if (this.getAnimation() == this.ATTACK_ANIMATION && this.getAnimationTick() == 7 && this.func_70638_az() != null) {
            this.doAttack();
        }
        if (this.isInWaterMaterial()) {
            this.setSwimming(true);
        } else {
            this.setSwimming(false);
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(this.ATTACK_ANIMATION);
        }
        return false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWIMMING, (Object)false);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Swimming", this.isSwimming);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSwimming(compound.func_74767_n("Swimming"));
    }

    public boolean isSwimming() {
        if (this.field_70170_p.field_72995_K) {
            boolean isSwimming;
            this.isSwimming = isSwimming = ((Boolean)this.field_70180_af.func_187225_a(SWIMMING)).booleanValue();
            return isSwimming;
        }
        return this.isSwimming;
    }

    public void setSwimming(boolean swimming) {
        this.field_70180_af.func_187227_b(SWIMMING, (Object)swimming);
        if (!this.field_70170_p.field_72995_K) {
            this.isSwimming = swimming;
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        return FASoundRegistry.MEGALOGRAPTUS_LIVING;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return FASoundRegistry.MEGALOGRAPTUS_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return FASoundRegistry.MEGALOGRAPTUS_DEATH;
    }

    @Override
    public boolean canBeRidden() {
        return false;
    }
}

