/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.world.gen;

import fossilsarcheology.server.block.FABlockRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenSigillaria
extends WorldGenerator {
    private static final IBlockState LOG = FABlockRegistry.SIGILLARIA_LOG.func_176223_P().func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)EnumFacing.Axis.Y);
    private static final IBlockState LEAF = FABlockRegistry.SIGILLARIA_LEAVES.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
    private boolean keepGenerating = true;

    public static boolean canGenTree(World world, BlockPos pos) {
        for (int y = 0; y <= 30; ++y) {
            if (WorldGenSigillaria.isReplaceable(world, pos.func_177981_b(y))) continue;
            return false;
        }
        return true;
    }

    private static boolean isReplaceable(World world, BlockPos pos) {
        return world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) || world.func_180495_p(pos).func_177230_c() == FABlockRegistry.SIGILLARIA_SAPLING || world.func_180495_p(pos).func_177230_c().isLeaves(world.func_180495_p(pos), (IBlockAccess)world, pos);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        Block j1 = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        this.keepGenerating = true;
        boolean twins = rand.nextInt(4) != 0;
        int height = rand.nextInt(7) + 15;
        if (j1 != Blocks.field_150349_c && j1 != Blocks.field_150346_d || pos.func_177956_o() >= 115) {
            return false;
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            this.setBlockState(world, pos.func_177967_a(facing, 2), LOG.func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)facing.func_176740_k()));
        }
        for (int i = 0; i < height; ++i) {
            this.setBlockState(world, pos.func_177981_b(i), LOG);
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                float f = i;
                int n = twins ? -2 : 4;
                if (!(f < (float)(height - n) * 0.65f)) continue;
                this.setBlockState(world, pos.func_177981_b(i).func_177972_a(facing), LOG);
            }
        }
        BlockPos top = pos.func_177981_b(height);
        if (twins) {
            EnumFacing direction = EnumFacing.func_176731_b((int)rand.nextInt(4));
            float bushWidth = (float)rand.nextInt(2) + 2.0f;
            int secondHeight = 3 + rand.nextInt(2) + (int)bushWidth;
            for (int i = 0; i <= secondHeight; ++i) {
                BlockPos offsetLeft = top.func_177967_a(direction, i).func_177981_b(i);
                BlockPos offsetRight = top.func_177967_a(direction.func_176734_d(), i).func_177981_b(i);
                this.setBlockState(world, offsetLeft, LOG);
                this.setBlockState(world, offsetRight, LOG);
                int bushHeight = rand.nextInt(2) + 6;
                if (i != secondHeight) continue;
                this.genCone(world, offsetLeft.func_177981_b(bushHeight / 2).func_177967_a(direction, -1), bushWidth, bushHeight, rand);
                this.genCone(world, offsetRight.func_177981_b(bushHeight / 2).func_177967_a(direction.func_176734_d(), -1), bushWidth, bushHeight, rand);
            }
        } else {
            this.genCone(world, top.func_177979_c(2), (float)rand.nextInt(2) + 2.0f, rand.nextInt(2) + 6, rand);
        }
        return true;
    }

    private void genCone(World world, BlockPos pos, float size, float height, Random random) {
        float f = (size + height + size) * 0.333f + 0.5f;
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)pos.func_177963_a((double)(-size), (double)(-height), (double)(-size)), (BlockPos)pos.func_177963_a((double)size, (double)height, (double)size))) {
            int distanceX = Math.abs(blockpos.func_177958_n() - pos.func_177958_n());
            int distanceZ = Math.abs(blockpos.func_177952_p() - pos.func_177952_p());
            int distanceY = Math.abs(blockpos.func_177956_o() - pos.func_177956_o());
            if (!(blockpos.func_177951_i((Vec3i)pos) <= (double)(f * f)) || !((float)(distanceX * distanceX + distanceZ * distanceZ) < f * f * (0.5f + random.nextFloat() * 0.5f) * ((float)(1 - distanceY % 2) + 0.25f))) continue;
            this.setBlockState(world, blockpos, LEAF);
        }
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)pos.func_177979_c((int)height), (BlockPos)pos.func_177981_b((int)height - 4))) {
            if (!(blockpos.func_177951_i((Vec3i)pos) <= (double)(f * f))) continue;
            this.setBlockState(world, blockpos, LOG);
        }
    }

    public void setBlockState(World world, BlockPos pos, IBlockState state) {
        if (WorldGenSigillaria.isReplaceable(world, pos)) {
            world.func_175656_a(pos, state);
        }
    }
}

