/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.arl.block.BlockMod;
import vazkii.arl.block.BlockModStairs;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.block.BlockQuarkStairs;
import vazkii.quark.base.handler.BiomeTypeConfigHandler;
import vazkii.quark.base.handler.DimensionConfig;
import vazkii.quark.base.handler.ModIntegrationHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.GlobalConfig;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.building.feature.VanillaWalls;
import vazkii.quark.world.block.BlockJasper;
import vazkii.quark.world.block.BlockLimestone;
import vazkii.quark.world.block.BlockMarble;
import vazkii.quark.world.block.BlockSlate;
import vazkii.quark.world.block.slab.BlockBasicStoneSlab;
import vazkii.quark.world.world.StoneInfoBasedGenerator;

public class RevampStoneGen
extends Feature {
    public static BlockMod marble;
    public static BlockMod limestone;
    public static BlockMod jasper;
    public static BlockMod slate;
    public static boolean enableStairsAndSlabs;
    public static boolean enableWalls;
    public static boolean outputCSV;
    public static boolean generateBasedOnBiomes;
    public static boolean enableMarble;
    public static boolean enableLimestone;
    public static boolean enableJasper;
    public static boolean enableSlate;
    public static StoneInfo graniteInfo;
    public static StoneInfo dioriteInfo;
    public static StoneInfo andesiteInfo;
    public static StoneInfo marbleInfo;
    public static StoneInfo limestoneInfo;
    public static StoneInfo jasperInfo;
    public static StoneInfo slateInfo;
    private static List<StoneInfoBasedGenerator> generators;
    private Queue<Runnable> deferedInit = new ArrayDeque<Runnable>();

    @Override
    public void setupConfig() {
        enableStairsAndSlabs = this.loadPropBool("Enable stairs and slabs", "", true) && GlobalConfig.enableVariants;
        enableWalls = this.loadPropBool("Enable walls", "", true) && GlobalConfig.enableVariants;
        enableMarble = this.loadPropBool("Enable Marble", "", true);
        enableLimestone = this.loadPropBool("Enable Limestone", "", true);
        enableJasper = this.loadPropBool("Enable Jasper", "", true);
        enableSlate = this.loadPropBool("Enable Slate", "", true);
        generateBasedOnBiomes = this.loadPropBool("Generate Based on Biomes", "Note: The stone rarity values are tuned based on this being true. If you turn it off, also change the stones' rarity (around 50 is fine).", true);
        outputCSV = this.loadPropBool("Output CSV Debug Info", "If this is true, CSV debug info will be printed out to the console on init, to help test biome spreads.", false);
        int defSize = 14;
        int defRarity = 9;
        int defUpper = 80;
        int defLower = 20;
        graniteInfo = this.loadStoneInfo("granite", defSize, defRarity, defUpper, defLower, true, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS);
        dioriteInfo = this.loadStoneInfo("diorite", defSize, defRarity, defUpper, defLower, true, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.MUSHROOM);
        andesiteInfo = this.loadStoneInfo("andesite", defSize, defRarity, defUpper, defLower, true, BiomeDictionary.Type.FOREST);
        marbleInfo = this.loadStoneInfo("marble", defSize, defRarity, defUpper, defLower, enableMarble, BiomeDictionary.Type.PLAINS);
        limestoneInfo = this.loadStoneInfo("limestone", defSize, defRarity, defUpper, defLower, enableLimestone, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.OCEAN);
        jasperInfo = this.loadStoneInfo("jasper", defSize, defRarity, defUpper, defLower, enableJasper, BiomeDictionary.Type.MESA, BiomeDictionary.Type.SANDY);
        slateInfo = this.loadStoneInfo("slate", defSize, defRarity, defUpper, defLower, enableSlate, BiomeDictionary.Type.COLD);
    }

    public StoneInfo loadStoneInfo(String name, int clusterSize, int clusterRarity, int upperBound, int lowerBound, boolean enabled, BiomeDictionary.Type ... biomes) {
        return RevampStoneGen.loadStoneInfo(this.configCategory, name, clusterSize, clusterRarity, upperBound, lowerBound, enabled, "0", biomes);
    }

    public static StoneInfo loadStoneInfo(String configCategory, String name, int clusterSize, int clusterRarity, int upperBound, int lowerBound, boolean enabled, String dims, BiomeDictionary.Type ... biomes) {
        String category = configCategory + "." + name;
        return new StoneInfo(category, clusterSize, clusterRarity, upperBound, lowerBound, enabled, dims, biomes);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        generators = new ArrayList<StoneInfoBasedGenerator>();
        IBlockState graniteState = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE);
        IBlockState dioriteState = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE);
        IBlockState andesiteState = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE);
        generators.add(new StoneInfoBasedGenerator(() -> graniteInfo, graniteState, "granite"));
        generators.add(new StoneInfoBasedGenerator(() -> dioriteInfo, dioriteState, "diorite"));
        generators.add(new StoneInfoBasedGenerator(() -> andesiteInfo, andesiteState, "andesite"));
        marble = this.makeStone(BlockMarble.class, "marble", marbleInfo, enableMarble);
        limestone = this.makeStone(BlockLimestone.class, "limestone", limestoneInfo, enableLimestone);
        jasper = this.makeStone(BlockJasper.class, "jasper", jasperInfo, enableJasper);
        slate = this.makeStone(BlockSlate.class, "slate", slateInfo, enableSlate);
        if (outputCSV) {
            BiomeTypeConfigHandler.debugStoneGeneration(generators);
        }
    }

    private BlockMod makeStone(Class<? extends BlockMod> clazz, String name, StoneInfo info, boolean enable) {
        if (!enable) {
            return null;
        }
        try {
            BlockMod block = clazz.newInstance();
            if (enableStairsAndSlabs) {
                BlockBasicStoneSlab.initSlab((Block)block, 0, "stone_" + name + "_slab");
                BlockModStairs.initStairs((Block)block, (int)0, (BlockStairs)new BlockQuarkStairs("stone_" + name + "_stairs", block.func_176223_P()));
            }
            VanillaWalls.add(name, (Block)block, 0, enableWalls);
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)block, (int)4, (int)1), (Object[])new Object[]{"BB", "BB", Character.valueOf('B'), ProxyRegistry.newStack((Block)block, (int)1, (int)0)});
            generators.add(new StoneInfoBasedGenerator(() -> info, block.func_176223_P(), name));
            String capName = WordUtils.capitalize((String)name);
            RevampStoneGen.addOreDict("stone" + capName, ProxyRegistry.newStack((Block)block, (int)1, (int)0));
            RevampStoneGen.addOreDict("stone" + capName + "Polished", ProxyRegistry.newStack((Block)block, (int)1, (int)1));
            this.deferedInit.add(() -> {
                ModIntegrationHandler.registerChiselVariant(name, ProxyRegistry.newStack((Block)block, (int)1, (int)0));
                ModIntegrationHandler.registerChiselVariant(name, ProxyRegistry.newStack((Block)block, (int)1, (int)1));
            });
            return block;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void init() {
        while (!this.deferedInit.isEmpty()) {
            this.deferedInit.poll().run();
        }
    }

    @SubscribeEvent
    public void onOreGenerate(OreGenEvent.GenerateMinable event) {
        switch (event.getType()) {
            case GRANITE: {
                if (!RevampStoneGen.graniteInfo.enabled) break;
                event.setResult(Event.Result.DENY);
                break;
            }
            case DIORITE: {
                if (!RevampStoneGen.dioriteInfo.enabled) break;
                event.setResult(Event.Result.DENY);
                break;
            }
            case ANDESITE: {
                if (!RevampStoneGen.andesiteInfo.enabled) break;
                event.setResult(Event.Result.DENY);
                break;
            }
            case DIRT: {
                this.generateNewStones(event);
                break;
            }
        }
    }

    private void generateNewStones(OreGenEvent.GenerateMinable event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        Chunk chunk = world.func_175726_f(pos);
        for (StoneInfoBasedGenerator gen : generators) {
            gen.generate(chunk.field_76635_g, chunk.field_76647_h, world);
        }
    }

    @Override
    public boolean hasOreGenSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    public static class StoneInfo {
        public final boolean enabled;
        public final int clusterSize;
        public final int clusterRarity;
        public final int upperBound;
        public final int lowerBound;
        public final boolean clustersRarityPerChunk;
        public final DimensionConfig dims;
        public final List<BiomeDictionary.Type> allowedBiomes;

        private StoneInfo(String category, int clusterSize, int clusterRarity, int upperBound, int lowerBound, boolean enabled, String dimStr, BiomeDictionary.Type ... biomes) {
            this.enabled = ModuleLoader.config.getBoolean("Enabled", category, true, "") && enabled;
            this.clusterSize = ModuleLoader.config.getInt("Cluster Radius", category, clusterSize, 0, Integer.MAX_VALUE, "");
            this.clusterRarity = ModuleLoader.config.getInt("Cluster Rarity", category, clusterRarity, 0, Integer.MAX_VALUE, "Out of how many chunks would one of these clusters generate");
            this.upperBound = ModuleLoader.config.getInt("Y Level Max", category, upperBound, 0, 255, "");
            this.lowerBound = ModuleLoader.config.getInt("Y Level Min", category, lowerBound, 0, 255, "");
            this.clustersRarityPerChunk = ModuleLoader.config.getBoolean("Invert Cluster Rarity", category, false, "Setting this to true will make the 'Cluster Rarity' feature be X per chunk rather than 1 per X chunks");
            this.dims = new DimensionConfig(category, dimStr);
            this.allowedBiomes = BiomeTypeConfigHandler.parseBiomeTypeArrayConfig("Allowed Biome Types", category, biomes);
        }
    }
}

