/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.integration.jei;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.JustEnoughItems;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.network.packets.PacketJei;
import mezz.jei.network.packets.PacketRecipeTransfer;
import mezz.jei.startup.StackHelper;
import mezz.jei.transfer.BasicRecipeTransferInfo;
import mezz.jei.util.Log;
import mezz.jei.util.Translator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import vazkii.quark.oddities.inventory.ContainerBackpack;

public class BackpackRecipeTransferHandler
implements IRecipeTransferHandler<ContainerBackpack> {
    private final StackHelper stackHelper = Internal.getStackHelper();
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final IRecipeTransferInfo<ContainerBackpack> transferHelper;

    public BackpackRecipeTransferHandler(IRecipeTransferHandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
        this.transferHelper = new BasicRecipeTransferInfo(ContainerBackpack.class, "minecraft.crafting", 1, 4, 9, 63);
    }

    @Nonnull
    public Class<ContainerBackpack> getContainerClass() {
        return this.transferHelper.getContainerClass();
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@Nonnull ContainerBackpack container, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        ItemStack stack;
        if (!player.field_70170_p.field_72995_K) {
            String tooltipMessage = Translator.translateToLocal((String)"jei.tooltip.error.recipe.transfer.no.server");
            return this.handlerHelper.createUserErrorWithTooltip(tooltipMessage);
        }
        if (!this.transferHelper.canHandle((Container)container)) {
            return this.handlerHelper.createInternalError();
        }
        HashMap<Integer, Slot> inventorySlots = new HashMap<Integer, Slot>();
        for (Object slot : this.transferHelper.getInventorySlots((Container)container)) {
            inventorySlots.put(((Slot)slot).field_75222_d, (Slot)slot);
        }
        HashMap<Integer, Slot> craftingSlots = new HashMap<Integer, Slot>();
        for (Slot slot : this.transferHelper.getRecipeSlots((Container)container)) {
            craftingSlots.put(slot.field_75222_d, slot);
        }
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        int inputCount = 0;
        ImmutableSet badIndexes = ImmutableSet.of((Object)2, (Object)5, (Object)6, (Object)7, (Object)8);
        int inputIndex = 0;
        for (IGuiIngredient ingredient : itemStackGroup.getGuiIngredients().values()) {
            if (!ingredient.isInput()) continue;
            if (!ingredient.getAllIngredients().isEmpty()) {
                ++inputCount;
                if (badIndexes.contains(inputIndex)) {
                    String tooltipMessage = Translator.translateToLocal((String)"jei.tooltip.error.recipe.transfer.too.large.player.inventory");
                    return this.handlerHelper.createUserErrorWithTooltip(tooltipMessage);
                }
            }
            ++inputIndex;
        }
        ArrayList<IGuiIngredient> guiIngredients = new ArrayList<IGuiIngredient>();
        for (IGuiIngredient guiIngredient : itemStackGroup.getGuiIngredients().values()) {
            if (!guiIngredient.isInput()) continue;
            guiIngredients.add(guiIngredient);
        }
        GuiItemStackGroup playerInvItemStackGroup = new GuiItemStackGroup(null, 0);
        int[] playerGridIndexes = new int[]{0, 1, 3, 4};
        for (int i = 0; i < 4; ++i) {
            int index = playerGridIndexes[i];
            if (index >= guiIngredients.size()) continue;
            IGuiIngredient ingredient = (IGuiIngredient)guiIngredients.get(index);
            playerInvItemStackGroup.init(i, true, 0, 0);
            playerInvItemStackGroup.set(i, ingredient.getAllIngredients());
        }
        HashMap<Integer, ItemStack> availableItemStacks = new HashMap<Integer, ItemStack>();
        int filledCraftSlotCount = 0;
        int emptySlotCount = 0;
        for (Slot slot : craftingSlots.values()) {
            stack = slot.func_75211_c();
            if (stack.func_190926_b()) continue;
            if (!slot.func_82869_a(player)) {
                Log.get().error("Recipe Transfer helper {} does not work for container {}. Player can't move item out of Crafting Slot number {}", this.transferHelper.getClass(), ((Object)((Object)container)).getClass(), (Object)slot.field_75222_d);
                return this.handlerHelper.createInternalError();
            }
            ++filledCraftSlotCount;
            availableItemStacks.put(slot.field_75222_d, stack.func_77946_l());
        }
        for (Slot slot : inventorySlots.values()) {
            stack = slot.func_75211_c();
            if (!stack.func_190926_b()) {
                availableItemStacks.put(slot.field_75222_d, stack.func_77946_l());
                continue;
            }
            ++emptySlotCount;
        }
        if (filledCraftSlotCount - inputCount > emptySlotCount) {
            String message = Translator.translateToLocal((String)"jei.tooltip.error.recipe.transfer.inventory.full");
            return this.handlerHelper.createUserErrorWithTooltip(message);
        }
        StackHelper.MatchingItemsResult matchingItemsResult = this.stackHelper.getMatchingItems(availableItemStacks, playerInvItemStackGroup.getGuiIngredients());
        if (matchingItemsResult.missingItems.size() > 0) {
            String message = Translator.translateToLocal((String)"jei.tooltip.error.recipe.transfer.missing");
            matchingItemsResult = this.stackHelper.getMatchingItems(availableItemStacks, itemStackGroup.getGuiIngredients());
            return this.handlerHelper.createUserErrorForSlots(message, (Collection)matchingItemsResult.missingItems);
        }
        ArrayList craftingSlotIndexes = new ArrayList(craftingSlots.keySet());
        Collections.sort(craftingSlotIndexes);
        ArrayList inventorySlotIndexes = new ArrayList(inventorySlots.keySet());
        Collections.sort(inventorySlotIndexes);
        for (Map.Entry entry : matchingItemsResult.matchingItems.entrySet()) {
            int craftNumber = (Integer)entry.getKey();
            int slotNumber = (Integer)craftingSlotIndexes.get(craftNumber);
            if (slotNumber >= 0 && slotNumber < container.field_75151_b.size()) continue;
            Log.get().error("Recipes Transfer Helper {} references slot {} outside of the inventory's size {}", this.transferHelper.getClass(), (Object)slotNumber, (Object)container.field_75151_b.size());
            return this.handlerHelper.createInternalError();
        }
        if (doTransfer) {
            PacketRecipeTransfer packet = new PacketRecipeTransfer(matchingItemsResult.matchingItems, craftingSlotIndexes, inventorySlotIndexes, maxTransfer, false);
            JustEnoughItems.getProxy().sendPacketToServer((PacketJei)packet);
        }
        return null;
    }
}

