/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.entity.ai;

import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;

public class EntityAIFavorBlock
extends EntityAIBase {
    private final EntityCreature creature;
    private final double movementSpeed;
    private final Predicate<IBlockState> targetBlock;
    protected int runDelay;
    private int timeoutCounter;
    private int maxStayTicks;
    protected BlockPos destinationBlock = BlockPos.field_177992_a;

    public EntityAIFavorBlock(EntityCreature creature, double speed, Predicate<IBlockState> predicate) {
        this.creature = creature;
        this.movementSpeed = speed;
        this.targetBlock = predicate;
        this.func_75248_a(5);
    }

    public EntityAIFavorBlock(EntityCreature creature, double speed, Block block) {
        this(creature, speed, (IBlockState state) -> state.func_177230_c() == block);
    }

    public EntityAIFavorBlock(EntityCreature creature, double speed, IBlockState targetState) {
        this(creature, speed, (IBlockState state) -> state == targetState);
    }

    public boolean func_75250_a() {
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        }
        this.runDelay = 200 + this.creature.func_70681_au().nextInt(200);
        return this.searchForDestination();
    }

    public boolean func_75253_b() {
        return this.timeoutCounter >= -this.maxStayTicks && this.timeoutCounter <= 1200 && this.targetBlock.test(this.creature.field_70170_p.func_180495_p(this.destinationBlock));
    }

    public void func_75249_e() {
        this.creature.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)(this.destinationBlock.func_177956_o() + 1), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed);
        this.timeoutCounter = 0;
        this.maxStayTicks = this.creature.func_70681_au().nextInt(this.creature.func_70681_au().nextInt(1200) + 1200) + 1200;
    }

    public void func_75246_d() {
        if (this.creature.func_174831_c(this.destinationBlock.func_177984_a()) > 1.0) {
            ++this.timeoutCounter;
            if (this.timeoutCounter % 40 == 0) {
                this.creature.func_70661_as().func_75492_a((double)this.destinationBlock.func_177958_n() + 0.5, (double)(this.destinationBlock.func_177956_o() + 1), (double)this.destinationBlock.func_177952_p() + 0.5, this.movementSpeed);
            }
        } else {
            --this.timeoutCounter;
        }
    }

    private boolean searchForDestination() {
        double followRange = this.creature.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        double xBase = this.creature.field_70165_t;
        double yBase = this.creature.field_70163_u;
        double zBase = this.creature.field_70161_v;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int yShift = 0;
        while (yShift <= 1) {
            int seekDist = 0;
            while ((double)seekDist < followRange) {
                int xShift = 0;
                while (xShift <= seekDist) {
                    int zShift;
                    int n = zShift = xShift < seekDist && xShift > -seekDist ? seekDist : 0;
                    while (zShift <= seekDist) {
                        pos.func_189532_c(xBase + (double)xShift, yBase + (double)yShift - 1.0, zBase + (double)zShift);
                        if (this.creature.func_180485_d((BlockPos)pos) && this.targetBlock.test(this.creature.field_70170_p.func_180495_p((BlockPos)pos))) {
                            this.destinationBlock = pos;
                            return true;
                        }
                        zShift = zShift > 0 ? -zShift : 1 - zShift;
                    }
                    xShift = xShift > 0 ? -xShift : 1 - xShift;
                }
                ++seekDist;
            }
            yShift = yShift > 0 ? -yShift : 1 - yShift;
        }
        return false;
    }
}

