/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.Feature;
import vazkii.quark.world.client.render.RenderAshen;
import vazkii.quark.world.client.render.RenderDweller;
import vazkii.quark.world.entity.EntityAshen;
import vazkii.quark.world.entity.EntityDweller;

public class DepthMobs
extends Feature {
    public static int upperBound;
    public static boolean enableAshen;
    public static boolean enableDweller;
    public static int ashenWeight;
    public static int dwellerWeight;
    public static int ashenMaxPack;
    public static int dwellerMaxPack;
    public static int ashenMinPack;
    public static int dwellerMinPack;

    @Override
    public void setupConfig() {
        upperBound = this.loadPropInt("Highest Y level for spawns", "", 20);
        enableAshen = this.loadPropBool("Enable Ashen", "", true);
        enableDweller = this.loadPropBool("Enable Dweller", "", true);
        ashenWeight = this.loadPropInt("Ashen Spawn Weight", "(Skeleton is 100. The higher, the more will spawn)", 30);
        dwellerWeight = this.loadPropInt("Dweller Spawn Weight", "(Zombie is 100. The higher, the more will spawn)", 30);
        ashenMaxPack = this.loadPropInt("Largest Ashen spawn group", "", 2);
        dwellerMaxPack = this.loadPropInt("Largest Dweller spawn group", "", 2);
        ashenMinPack = this.loadPropInt("Smallest Ashen spawn group", "", 1);
        dwellerMinPack = this.loadPropInt("Smallest Dweller spawn group", "", 1);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (enableDweller) {
            String dwellerName = "quark:dweller";
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(dwellerName), EntityDweller.class, (String)dwellerName, (int)2, (Object)Quark.instance, (int)80, (int)3, (boolean)true, (int)4872516, (int)4136992);
            EntityRegistry.addSpawn(EntityDweller.class, (int)dwellerWeight, (int)dwellerMinPack, (int)dwellerMaxPack, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])DepthMobs.getBiomesWithMob(EntityZombie.class));
        }
        if (enableAshen) {
            String ashenName = "quark:ashen";
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(ashenName), EntityAshen.class, (String)ashenName, (int)1, (Object)Quark.instance, (int)80, (int)3, (boolean)true, (int)8618870, (int)5455164);
            EntityRegistry.addSpawn(EntityAshen.class, (int)ashenWeight, (int)ashenMinPack, (int)ashenMaxPack, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])DepthMobs.getBiomesWithMob(EntitySkeleton.class));
        }
    }

    @Override
    public void preInitClient() {
        if (enableDweller) {
            RenderingRegistry.registerEntityRenderingHandler(EntityDweller.class, RenderDweller.FACTORY);
        }
        if (enableAshen) {
            RenderingRegistry.registerEntityRenderingHandler(EntityAshen.class, RenderAshen.FACTORY);
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    public static Biome[] getBiomesWithMob(Class<? extends Entity> clazz) {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        block0: for (Biome b : Biome.field_185377_q) {
            List spawnList = b.func_76747_a(EnumCreatureType.MONSTER);
            for (Biome.SpawnListEntry e : spawnList) {
                if (e.field_76300_b != clazz) continue;
                biomes.add(b);
                continue block0;
            }
        }
        return biomes.toArray(new Biome[0]);
    }
}

