/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.feature;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.quark.base.module.Feature;
import vazkii.quark.vanity.item.ItemWitchHat;

public class WitchHat
extends Feature {
    public static Item witch_hat;
    public static boolean halveDamage;
    public static boolean witchesIgnoreYou;
    public static double dropRate;
    public static double lootingBoost;
    public static boolean verifyTruePlayer;

    @Override
    public void setupConfig() {
        halveDamage = this.loadPropBool("Halve witch damage", "", true);
        witchesIgnoreYou = this.loadPropBool("Make witches ignore players with witch hats", "", true);
        dropRate = this.loadPropDouble("Drop Chance from witches", "", 0.025);
        lootingBoost = this.loadPropDouble("Drop Chance boost per looting level", "", 0.01);
        verifyTruePlayer = this.loadPropBool("Only Drop on Player Kills", "", true);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        witch_hat = new ItemWitchHat();
    }

    @SubscribeEvent
    public void onDrops(LivingDropsEvent event) {
        if (event.getEntityLiving() instanceof EntityWitch && (!verifyTruePlayer || event.getSource().func_76346_g() instanceof EntityPlayer) && Math.random() < dropRate + lootingBoost * (double)event.getLootingLevel()) {
            event.getDrops().add(new EntityItem(event.getEntity().func_130014_f_(), event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, new ItemStack(witch_hat)));
        }
    }

    @SubscribeEvent
    public void onDamage(LivingHurtEvent event) {
        ItemStack hat;
        if (halveDamage && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityWitch && !(hat = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.HEAD)).func_190926_b() && hat.func_77973_b() == witch_hat) {
            event.setAmount(event.getAmount() / 2.0f);
        }
    }

    public static boolean hasWitchHat(EntityLiving attacker, @Nullable EntityLivingBase target) {
        if (!witchesIgnoreYou || !(attacker instanceof EntityWitch) || target == null) {
            return false;
        }
        ItemStack head = target.func_184582_a(EntityEquipmentSlot.HEAD);
        return !head.func_190926_b() && head.func_77973_b() == witch_hat;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

