/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.utils;

import java.util.HashMap;

public class ClassUtils {
    private static final HashMap<Class<?>, Class<?>> primitiveTypeMap = new HashMap();

    private ClassUtils() {
    }

    public static Class<?> mapPrimitiveToWrapper(Class<?> clazz) {
        Class<?> mappedClass = primitiveTypeMap.get(clazz);
        return mappedClass != null ? mappedClass : clazz;
    }

    public static boolean isParamCompatible(Class<?> type, Object obj) {
        if (obj == null && !type.isPrimitive()) {
            return true;
        }
        type = ClassUtils.mapPrimitiveToWrapper(type);
        return type.isInstance(obj);
    }

    public static boolean isParamsCompatible(Class<?>[] types, Object[] params) {
        if (types.length != params.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (ClassUtils.isParamCompatible(types[i], params[i])) continue;
            return false;
        }
        return true;
    }

    static {
        primitiveTypeMap.put(Boolean.TYPE, Boolean.class);
        primitiveTypeMap.put(Byte.TYPE, Byte.class);
        primitiveTypeMap.put(Short.TYPE, Short.class);
        primitiveTypeMap.put(Character.TYPE, Character.class);
        primitiveTypeMap.put(Integer.TYPE, Integer.class);
        primitiveTypeMap.put(Long.TYPE, Long.class);
        primitiveTypeMap.put(Float.TYPE, Float.class);
        primitiveTypeMap.put(Double.TYPE, Double.class);
    }
}

