/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.utils;

import java.lang.reflect.Array;

public class HashEntry<K, T extends HashEntry<K, T>> {
    public final K key;
    final int hash;
    T next;

    public HashEntry(K key) {
        this.key = key;
        this.hash = key.hashCode();
    }

    public T next() {
        return this.next;
    }

    public static <K, T extends HashEntry<K, T>> T get(T[] table, Object key) {
        K k;
        int hash = key.hashCode();
        T e = table[hash & table.length - 1];
        while (e != null && (((HashEntry)e).hash != hash || (k = ((HashEntry)e).key) != key && !key.equals(k))) {
            e = ((HashEntry)e).next;
        }
        return e;
    }

    public static <K, T extends HashEntry<K, T>> void insertEntry(T[] table, T newEntry) {
        int idx = newEntry.hash & table.length - 1;
        newEntry.next = table[idx];
        table[idx] = newEntry;
    }

    public static <K, T extends HashEntry<K, T>> T remove(T[] table, Object key) {
        K k;
        int hash = key.hashCode();
        int idx = hash & table.length - 1;
        T e = table[idx];
        Object p = null;
        while (e != null && (((HashEntry)e).hash != hash || (k = ((HashEntry)e).key) != key && !key.equals(k))) {
            p = e;
            e = ((HashEntry)e).next;
        }
        if (e != null) {
            if (p != null) {
                p.next = ((HashEntry)e).next;
            } else {
                table[idx] = ((HashEntry)e).next;
            }
        }
        return e;
    }

    public static <K, T extends HashEntry<K, T>> void remove(T[] table, T entry) {
        int idx = entry.hash & table.length - 1;
        T e = table[idx];
        if (e == entry) {
            table[idx] = ((HashEntry)e).next;
        } else {
            do {
                T p = e;
            } while ((e = ((HashEntry)e).next) != entry);
            ((HashEntry)p).next = ((HashEntry)e).next;
        }
    }

    public static <K, T extends HashEntry<K, T>> T[] maybeResizeTable(T[] table, int usedCount) {
        if (usedCount * 4 > table.length * 3) {
            table = HashEntry.resizeTable(table, (int)(table.length * 2));
        }
        return table;
    }

    private static <K, T extends HashEntry<K, T>> T[] resizeTable(T[] table, int newSize) {
        if (newSize < 4 || (newSize & newSize - 1) != 0) {
            throw new IllegalArgumentException("newSize");
        }
        HashEntry[] newTable = (HashEntry[])Array.newInstance(table.getClass().getComponentType(), newSize);
        for (T e : table) {
            while (e != null) {
                T ne = ((HashEntry)e).next;
                int ni = ((HashEntry)e).hash & newSize - 1;
                ((HashEntry)e).next = newTable[ni];
                newTable[ni] = e;
                e = ne;
            }
        }
        return newTable;
    }
}

