/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.dimension;

import drzhark.mocreatures.dimension.MoCWorldGenPortal;
import drzhark.mocreatures.dimension.WorldGenTower;
import drzhark.mocreatures.init.MoCBlocks;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraft.world.gen.feature.WorldGenEndIsland;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkGeneratorWyvernLair
implements IChunkGenerator {
    private final Random rand;
    protected static final IBlockState WYVERN_STONE = MoCBlocks.mocStone.func_176223_P();
    protected static final IBlockState WYVERN_DIRT = MoCBlocks.mocDirt.func_176223_P();
    protected static final IBlockState WYVERN_GRASS = MoCBlocks.mocGrass.func_176223_P();
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    private NoiseGeneratorOctaves lperlinNoise1;
    private NoiseGeneratorOctaves lperlinNoise2;
    private NoiseGeneratorOctaves perlinNoise1;
    public NoiseGeneratorOctaves noiseGen5;
    public NoiseGeneratorOctaves noiseGen6;
    private final World world;
    private final boolean mapFeaturesEnabled;
    private NoiseGeneratorSimplex islandNoise;
    private double[] buffer;
    private Biome[] biomesForGeneration;
    double[] pnr;
    double[] ar;
    double[] br;
    private final WorldGenEndIsland endIslands = new WorldGenEndIsland();
    private int chunkX = 0;
    private int chunkZ = 0;
    private boolean towerDone = false;
    private boolean portalDone = false;

    public ChunkGeneratorWyvernLair(World worldIn, boolean mapFeaturesEnabledIn, long seed) {
        this.world = worldIn;
        this.mapFeaturesEnabled = mapFeaturesEnabledIn;
        this.rand = new Random(seed);
        this.lperlinNoise1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.lperlinNoise2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.perlinNoise1 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.islandNoise = new NoiseGeneratorSimplex(this.rand);
        InitNoiseGensEvent.ContextEnd ctx = new InitNoiseGensEvent.ContextEnd(this.lperlinNoise1, this.lperlinNoise2, this.perlinNoise1, this.noiseGen5, this.noiseGen6, this.islandNoise);
        ctx = (InitNoiseGensEvent.ContextEnd)TerrainGen.getModdedNoiseGenerators((World)worldIn, (Random)this.rand, (InitNoiseGensEvent.Context)ctx);
        this.lperlinNoise1 = ctx.getLPerlin1();
        this.lperlinNoise2 = ctx.getLPerlin2();
        this.perlinNoise1 = ctx.getPerlin();
        this.noiseGen5 = ctx.getDepth();
        this.noiseGen6 = ctx.getScale();
        this.islandNoise = ctx.getIsland();
    }

    public void setBlocksInChunk(int x, int z, ChunkPrimer primer) {
        int i = 2;
        int j = 3;
        int k = 33;
        int l = 3;
        this.buffer = this.getHeights(this.buffer, x * 2, 0, z * 2, 3, 33, 3);
        for (int i1 = 0; i1 < 2; ++i1) {
            for (int j1 = 0; j1 < 2; ++j1) {
                for (int k1 = 0; k1 < 32; ++k1) {
                    double d0 = 0.25;
                    double d1 = this.buffer[((i1 + 0) * 3 + j1 + 0) * 33 + k1 + 0];
                    double d2 = this.buffer[((i1 + 0) * 3 + j1 + 1) * 33 + k1 + 0];
                    double d3 = this.buffer[((i1 + 1) * 3 + j1 + 0) * 33 + k1 + 0];
                    double d4 = this.buffer[((i1 + 1) * 3 + j1 + 1) * 33 + k1 + 0];
                    double d5 = (this.buffer[((i1 + 0) * 3 + j1 + 0) * 33 + k1 + 1] - d1) * 0.25;
                    double d6 = (this.buffer[((i1 + 0) * 3 + j1 + 1) * 33 + k1 + 1] - d2) * 0.25;
                    double d7 = (this.buffer[((i1 + 1) * 3 + j1 + 0) * 33 + k1 + 1] - d3) * 0.25;
                    double d8 = (this.buffer[((i1 + 1) * 3 + j1 + 1) * 33 + k1 + 1] - d4) * 0.25;
                    for (int l1 = 0; l1 < 4; ++l1) {
                        double d9 = 0.125;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.125;
                        double d13 = (d4 - d2) * 0.125;
                        for (int i2 = 0; i2 < 8; ++i2) {
                            double d14 = 0.125;
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.125;
                            for (int j2 = 0; j2 < 8; ++j2) {
                                IBlockState iblockstate = AIR;
                                if (d15 > 0.0) {
                                    iblockstate = WYVERN_STONE;
                                }
                                int k2 = i2 + i1 * 8;
                                int l2 = l1 + k1 * 4;
                                int i3 = j2 + j1 * 8;
                                primer.func_177855_a(k2, l2, i3, iblockstate);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void buildSurfaces(ChunkPrimer primer) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)this.chunkX, (int)this.chunkZ, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int b0 = 5;
                int k = -1;
                IBlockState iblockstateTopBlock = WYVERN_GRASS;
                IBlockState iblockstateFillerBlock = WYVERN_DIRT;
                for (int l = 127; l >= 0; --l) {
                    IBlockState iblockstate2 = primer.func_177856_a(i, l, j);
                    if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                        k = -1;
                        continue;
                    }
                    if (iblockstate2.func_177230_c() != WYVERN_STONE.func_177230_c()) continue;
                    if (k == -1) {
                        k = b0;
                        if (l >= 0) {
                            primer.func_177855_a(i, l, j, iblockstateTopBlock);
                            continue;
                        }
                        primer.func_177855_a(i, l, j, iblockstateFillerBlock);
                        continue;
                    }
                    if (k <= 0) continue;
                    --k;
                    primer.func_177855_a(i, l, j, iblockstateFillerBlock);
                }
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.chunkX = x;
        this.chunkZ = z;
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.setBlocksInChunk(x, z, chunkprimer);
        this.buildSurfaces(chunkprimer);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private float getIslandHeightValue(int p_185960_1_, int p_185960_2_, int p_185960_3_, int p_185960_4_) {
        float f = p_185960_1_ * 2 + p_185960_3_;
        float f1 = p_185960_2_ * 2 + p_185960_4_;
        float f2 = 100.0f - MathHelper.func_76129_c((float)(f * f + f1 * f1)) * 8.0f;
        if (f2 > 80.0f) {
            f2 = 80.0f;
        }
        if (f2 < -100.0f) {
            f2 = -100.0f;
        }
        for (int i = -12; i <= 12; ++i) {
            for (int j = -12; j <= 12; ++j) {
                long k = p_185960_1_ + i;
                long l = p_185960_2_ + j;
                if (k * k + l * l <= 4096L || !(this.islandNoise.func_151605_a((double)k, (double)l) < (double)-0.9f)) continue;
                float f3 = (MathHelper.func_76135_e((float)k) * 3439.0f + MathHelper.func_76135_e((float)l) * 147.0f) % 13.0f + 9.0f;
                f = p_185960_3_ - i * 2;
                f1 = p_185960_4_ - j * 2;
                float f4 = 100.0f - MathHelper.func_76129_c((float)(f * f + f1 * f1)) * f3;
                if (f4 > 80.0f) {
                    f4 = 80.0f;
                }
                if (f4 < -100.0f) {
                    f4 = -100.0f;
                }
                if (!(f4 > f2)) continue;
                f2 = f4;
            }
        }
        return f2;
    }

    private double[] getHeights(double[] p_185963_1_, int p_185963_2_, int p_185963_3_, int p_185963_4_, int p_185963_5_, int p_185963_6_, int p_185963_7_) {
        ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this, p_185963_1_, p_185963_2_, p_185963_3_, p_185963_4_, p_185963_5_, p_185963_6_, p_185963_7_);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getNoisefield();
        }
        if (p_185963_1_ == null) {
            p_185963_1_ = new double[p_185963_5_ * p_185963_6_ * p_185963_7_];
        }
        double d0 = 684.412;
        double d1 = 684.412;
        this.pnr = this.perlinNoise1.func_76304_a(this.pnr, p_185963_2_, p_185963_3_, p_185963_4_, p_185963_5_, p_185963_6_, p_185963_7_, (d0 *= 2.0) / 80.0, 4.277575000000001, d0 / 80.0);
        this.ar = this.lperlinNoise1.func_76304_a(this.ar, p_185963_2_, p_185963_3_, p_185963_4_, p_185963_5_, p_185963_6_, p_185963_7_, d0, 684.412, d0);
        this.br = this.lperlinNoise2.func_76304_a(this.br, p_185963_2_, p_185963_3_, p_185963_4_, p_185963_5_, p_185963_6_, p_185963_7_, d0, 684.412, d0);
        int i = p_185963_2_ / 2;
        int j = p_185963_4_ / 2;
        int k = 0;
        for (int l = 0; l < p_185963_5_; ++l) {
            for (int i1 = 0; i1 < p_185963_7_; ++i1) {
                float f = this.getIslandHeightValue(i, j, l, i1);
                for (int j1 = 0; j1 < p_185963_6_; ++j1) {
                    double d2 = this.ar[k] / 512.0;
                    double d3 = this.br[k] / 512.0;
                    double d5 = (this.pnr[k] / 10.0 + 1.0) / 2.0;
                    double d4 = d5 < 0.0 ? d2 : (d5 > 1.0 ? d3 : d2 + (d3 - d2) * d5);
                    d4 -= 8.0;
                    d4 += (double)f;
                    int k1 = 2;
                    if (j1 > p_185963_6_ / 2 - k1) {
                        double d6 = (float)(j1 - (p_185963_6_ / 2 - k1)) / 64.0f;
                        d6 = MathHelper.func_151237_a((double)d6, (double)0.0, (double)1.0);
                        d4 = d4 * (1.0 - d6) + -3000.0 * d6;
                    }
                    if (j1 < (k1 = 8)) {
                        double d7 = (float)(k1 - j1) / ((float)k1 - 1.0f);
                        d4 = d4 * (1.0 - d7) + -30.0 * d7;
                    }
                    p_185963_1_[k] = d4;
                    ++k;
                }
            }
        }
        return p_185963_1_;
    }

    public void func_185931_b(int x, int z) {
        int var14;
        int var13;
        int var12;
        BlockFalling.field_149832_M = true;
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false);
        int var4 = x * 16;
        int var5 = z * 16;
        BlockPos blockpos = new BlockPos(var4 + 16, 0, var5 + 16);
        Biome var6 = this.world.func_180494_b(blockpos);
        boolean var11 = false;
        if (!var11 && this.rand.nextInt(2) == 0) {
            var12 = var4 + this.rand.nextInt(16) + 8;
            var13 = this.rand.nextInt(128);
            var14 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.rand, new BlockPos(var12, var13, var14));
        }
        if (!var11 && this.rand.nextInt(8) == 0) {
            var12 = var4 + this.rand.nextInt(16) + 8;
            var13 = this.rand.nextInt(this.rand.nextInt(120) + 8);
            var14 = var5 + this.rand.nextInt(16) + 8;
            if (var13 < 63 || this.rand.nextInt(10) == 0) {
                new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.world, this.rand, new BlockPos(var12, var13, var14));
            }
        }
        var6.func_180624_a(this.world, this.rand, new BlockPos(var4, 0, var5));
        if (x == 0 && z == 0 && !this.portalDone) {
            this.createPortal(this.world, this.rand);
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false);
        BlockFalling.field_149832_M = false;
    }

    public void generateTower(World par1World, Random par2Random, int par3, int par4) {
        WorldGenTower myTower = new WorldGenTower((Block)Blocks.field_150349_c, (Block)Blocks.field_150334_T, Blocks.field_150369_x);
        if (!this.towerDone) {
            int randPosX = par3 + par2Random.nextInt(16) + 8;
            int randPosZ = par4 + par2Random.nextInt(16) + 8;
            this.towerDone = myTower.func_180709_b(par1World, par2Random, new BlockPos(randPosX, 61, randPosZ));
        }
    }

    public void createPortal(World par1World, Random par2Random) {
        MoCWorldGenPortal myPortal = new MoCWorldGenPortal(Blocks.field_150371_ca, 2, Blocks.field_150370_cb, 0, Blocks.field_150371_ca, 1, Blocks.field_150371_ca, 0);
        for (int i = 0; i < 16; ++i) {
            if (this.portalDone) continue;
            int randPosY = 56 + i;
            this.portalDone = myPortal.func_180709_b(par1World, par2Random, new BlockPos(0, randPosY, 0));
        }
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.world.func_180494_b(pos).func_76747_a(creatureType);
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }
}

