/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.block;

import com.mrcrayfish.vehicle.block.BlockObject;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.tileentity.TileEntityFluidPipe;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class BlockFluidPipe
extends BlockObject {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool[] CONNECTED_PIPES = new PropertyBool[EnumFacing.values().length];
    protected List<AxisAlignedBB> boxes;
    protected AxisAlignedBB boxCenter;
    protected String name;

    public BlockFluidPipe() {
        this("vehicle:fluid_pipe");
        this.func_149711_c(0.5f);
    }

    public BlockFluidPipe(String name) {
        super(Material.field_151573_f, name);
        this.name = name;
        IBlockState defaultState = this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
        for (EnumFacing facing : EnumFacing.values()) {
            defaultState = defaultState.func_177226_a((IProperty)CONNECTED_PIPES[facing.func_176745_a()], (Comparable)Boolean.valueOf(false));
        }
        this.func_180632_j(defaultState);
        this.boxCenter = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);
        this.boxes = Stream.of(new AxisAlignedBB(0.34375, 0.0, 0.34375, 0.65625, 0.3125, 0.65625), new AxisAlignedBB(0.34375, 0.6875, 0.34375, 0.65625, 1.0, 0.65625), new AxisAlignedBB(0.34375, 0.34375, 0.0, 0.65625, 0.65625, 0.3125), new AxisAlignedBB(0.34375, 0.34375, 0.6875, 0.65625, 0.65625, 1.0), new AxisAlignedBB(0.0, 0.34375, 0.34375, 0.3125, 0.65625, 0.65625), new AxisAlignedBB(0.6875, 0.34375, 0.34375, 1.0, 0.65625, 0.65625), this.boxCenter).collect(Collectors.toList());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (GuiScreen.func_146272_n()) {
            String info = I18n.func_135052_a((String)(this.func_149739_a() + ".info"), (Object[])new Object[0]);
            tooltip.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(info, 150));
        } else {
            tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.info_help", (Object[])new Object[0]));
        }
    }

    protected EnumFacing getCollisionFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)FACING);
    }

    @Nullable
    public static TileEntityFluidPipe getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity instanceof TileEntityFluidPipe ? (TileEntityFluidPipe)tileEntity : null;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        int i;
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)world, pos);
        }
        boolean[] disabledConnections = TileEntityFluidPipe.getDisabledConnections(BlockFluidPipe.getTileEntity((IBlockAccess)world, pos));
        for (i = 0; i < EnumFacing.values().length; ++i) {
            if (!((Boolean)state.func_177229_b((IProperty)CONNECTED_PIPES[i])).booleanValue() || disabledConnections[i]) continue;
            BlockFluidPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.boxes.get(i));
        }
        for (i = EnumFacing.values().length; i < this.boxes.size(); ++i) {
            BlockFluidPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.boxes.get(i));
        }
        BlockFluidPipe.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.boxes.get(this.getCollisionFacing(state).func_176745_a()));
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        double distanceSqShortest = Double.POSITIVE_INFINITY;
        RayTraceResult resultClosest = null;
        IBlockState state = world.func_180495_p(pos);
        if (!((state = state.func_185899_b((IBlockAccess)world, pos)).func_177230_c() instanceof BlockFluidPipe)) {
            return null;
        }
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        this.func_185477_a(state, world, pos, Block.field_185505_j.func_186670_a(pos), boxes, null, true);
        for (AxisAlignedBB box : boxes) {
            double distanceSq;
            RayTraceResult result = box.func_72327_a(start, end);
            if (result == null || !((distanceSq = result.field_72307_f.func_72436_e(start)) < distanceSqShortest)) continue;
            distanceSqShortest = distanceSq;
            resultClosest = result;
        }
        return resultClosest == null ? resultClosest : new RayTraceResult(RayTraceResult.Type.BLOCK, resultClosest.field_72307_f, resultClosest.field_178784_b, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        double minX = 0.3125;
        double minY = 0.3125;
        double minZ = 0.3125;
        double maxX = 0.6875;
        double maxY = 0.6875;
        double maxZ = 0.6875;
        state = this.func_176221_a(state, source, pos);
        EnumFacing originalFacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (originalFacing) {
            case DOWN: {
                minY = 0.0;
                break;
            }
            case UP: {
                maxY = 1.0;
                break;
            }
            case NORTH: {
                minZ = 0.0;
                break;
            }
            case SOUTH: {
                maxZ = 1.0;
                break;
            }
            case WEST: {
                minX = 0.0;
                break;
            }
            case EAST: {
                maxX = 1.0;
            }
        }
        boolean[] disabledConnections = TileEntityFluidPipe.getDisabledConnections(BlockFluidPipe.getTileEntity(source, pos));
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_PIPES[EnumFacing.NORTH.func_176745_a()])).booleanValue() && !disabledConnections[EnumFacing.NORTH.func_176745_a()]) {
            minZ = 0.0;
        }
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_PIPES[EnumFacing.EAST.func_176745_a()])).booleanValue() && !disabledConnections[EnumFacing.EAST.func_176745_a()]) {
            maxX = 1.0;
        }
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_PIPES[EnumFacing.SOUTH.func_176745_a()])).booleanValue() && !disabledConnections[EnumFacing.SOUTH.func_176745_a()]) {
            maxZ = 1.0;
        }
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_PIPES[EnumFacing.WEST.func_176745_a()])).booleanValue() && !disabledConnections[EnumFacing.WEST.func_176745_a()]) {
            minX = 0.0;
        }
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_PIPES[EnumFacing.DOWN.func_176745_a()])).booleanValue() && !disabledConnections[EnumFacing.DOWN.func_176745_a()]) {
            minY = 0.0;
        }
        if (((Boolean)state.func_177229_b((IProperty)CONNECTED_PIPES[EnumFacing.UP.func_176745_a()])).booleanValue() && !disabledConnections[EnumFacing.UP.func_176745_a()]) {
            maxY = 1.0;
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityFluidPipe pipe = BlockFluidPipe.getTileEntity((IBlockAccess)world, pos);
        Pair<AxisAlignedBB, EnumFacing> hit = this.getWrenchableBox(world, pos, state, player, hand, facing, hitX, hitY, hitZ, pipe);
        if (pipe != null && hit != null) {
            pipe.setConnectionDisabled(facing, !pipe.isConnectionDisabled(facing = (EnumFacing)hit.getRight()));
            world.func_147458_c(pos.func_177958_n() - 1, pos.func_177956_o() - 1, pos.func_177952_p() - 1, pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1);
            world.func_175684_a(pos, state.func_177230_c(), 0);
            world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187605_cG, SoundCategory.BLOCKS, 1.0f, 2.0f);
            return true;
        }
        return false;
    }

    @Nullable
    public Pair<AxisAlignedBB, EnumFacing> getWrenchableBox(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, double hitX, double hitY, double hitZ, @Nullable TileEntityFluidPipe pipe) {
        if (pipe == null || player.func_184586_b(hand).func_77973_b() != ModItems.WRENCH) {
            return null;
        }
        state = state.func_185899_b((IBlockAccess)world, pos);
        Vec3d hit = new Vec3d(hitX, hitY, hitZ);
        for (int i = 0; i < EnumFacing.values().length + 1; ++i) {
            boolean isCenter;
            boolean bl = isCenter = i == EnumFacing.values().length;
            if (!isCenter && !((Boolean)state.func_177229_b((IProperty)CONNECTED_PIPES[i])).booleanValue() || !this.boxes.get(i).func_186662_g(0.001).func_72318_a(hit)) continue;
            if (!isCenter) {
                facing = EnumFacing.func_82600_a((int)i);
            } else if (!((Boolean)state.func_177229_b((IProperty)CONNECTED_PIPES[facing.func_176745_a()])).booleanValue()) {
                BlockPos adjacentPos = pos.func_177972_a(facing);
                IBlockState adjacentState = world.func_180495_p(adjacentPos);
                TileEntity tileEntity = world.func_175625_s(adjacentPos);
                Block adjacentBlock = adjacentState.func_177230_c();
                if (this == ModBlocks.FLUID_PUMP && adjacentBlock == ModBlocks.FLUID_PUMP || this == ModBlocks.FLUID_PIPE && adjacentBlock == ModBlocks.FLUID_PIPE && this.getCollisionFacing(adjacentState) != facing.func_176734_d() || tileEntity == null || !tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) {
                    return null;
                }
            }
            if (world.func_180495_p(pos.func_177972_a(facing)).func_177230_c() == Blocks.field_150442_at || this.getCollisionFacing(state) == facing) continue;
            return new ImmutablePair((Object)this.boxes.get(i).func_186670_a(pos), (Object)facing);
        }
        return null;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing originalFacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        boolean[] disabledConnections = TileEntityFluidPipe.getDisabledConnections(BlockFluidPipe.getTileEntity(world, pos));
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            boolean enabled;
            if (facing == originalFacing) continue;
            BlockPos adjacentPos = pos.func_177972_a(facing);
            IBlockState adjacentState = world.func_180495_p(adjacentPos);
            boolean bl = enabled = !disabledConnections[facing.func_176745_a()];
            if (adjacentState.func_177230_c() == ModBlocks.FLUID_PIPE) {
                EnumFacing adjacentFacing = (EnumFacing)adjacentState.func_177229_b((IProperty)FACING);
                if (!adjacentPos.func_177972_a(adjacentFacing).equals((Object)pos)) continue;
                state = state.func_177226_a((IProperty)CONNECTED_PIPES[facing.func_176745_a()], (Comparable)Boolean.valueOf(enabled));
                continue;
            }
            if (adjacentState.func_177230_c() != ModBlocks.FLUID_PUMP) continue;
            state = state.func_177226_a((IProperty)CONNECTED_PIPES[facing.func_176745_a()], (Comparable)Boolean.valueOf(enabled));
        }
        return state;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        return state.func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        builder.add(new IProperty[]{FACING});
        builder.add((IProperty[])CONNECTED_PIPES);
        return builder.build();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityFluidPipe();
    }

    static {
        for (EnumFacing facing : EnumFacing.values()) {
            BlockFluidPipe.CONNECTED_PIPES[facing.func_176745_a()] = PropertyBool.func_177716_a((String)("pipe_" + facing.func_176610_l()));
        }
    }
}

