/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.block;

import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import com.mrcrayfish.vehicle.init.ModFluids;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.item.ItemJerryCan;
import com.mrcrayfish.vehicle.tileentity.TileEntityGasPump;
import com.mrcrayfish.vehicle.tileentity.TileEntityGasPumpTank;
import com.mrcrayfish.vehicle.util.Bounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockGasPump
extends BlockRotatedObject {
    public static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");
    private static final AxisAlignedBB[] COLLISION_BOXES = new Bounds(3, 0, 0, 13, 15, 16).getRotatedBounds();
    private static final AxisAlignedBB[] TOP_SELECTION_BOXES = new Bounds(3, -16, 0, 13, 15, 16).getRotatedBounds();
    private static final AxisAlignedBB[] BOTTOM_SELECTION_BOXES = new Bounds(3, 0, 0, 13, 31, 16).getRotatedBounds();

    public BlockGasPump() {
        super(Material.field_151574_g, "vehicle:gas_pump");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(1.0f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return (Boolean)state.func_177229_b((IProperty)TOP) != false ? TOP_SELECTION_BOXES[facing.func_176736_b()] : BOTTOM_SELECTION_BOXES[facing.func_176736_b()];
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_BOXES[facing.func_176736_b()]);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
                TileEntity tileEntity = worldIn.func_175625_s(pos);
                if (tileEntity instanceof TileEntityGasPump) {
                    TileEntityGasPump gasPump = (TileEntityGasPump)tileEntity;
                    if (gasPump.getFuelingEntity() != null && gasPump.getFuelingEntity().func_145782_y() == playerIn.func_145782_y()) {
                        gasPump.setFuelingEntity(null);
                        worldIn.func_184133_a(null, pos, ModSounds.NOZZLE_PUT_DOWN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    } else if (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176746_e().equals((Object)face)) {
                        gasPump.setFuelingEntity(playerIn);
                        worldIn.func_184133_a(null, pos, ModSounds.NOZZLE_PICK_UP, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                }
            } else {
                ItemStack stack = playerIn.func_184586_b(hand);
                if (FluidUtil.interactWithFluidHandler((EntityPlayer)playerIn, (EnumHand)hand, (World)worldIn, (BlockPos)pos, (EnumFacing)face)) {
                    return true;
                }
                if (stack.func_77973_b() instanceof ItemJerryCan) {
                    IFluidHandler handler;
                    ItemJerryCan jerryCan = (ItemJerryCan)stack.func_77973_b();
                    if (jerryCan.isFull(stack)) {
                        return false;
                    }
                    TileEntity tileEntity = worldIn.func_175625_s(pos);
                    if (tileEntity != null && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && (handler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) != null && handler instanceof FluidTank) {
                        int remaining;
                        FluidTank tank = (FluidTank)handler;
                        if (tank.getFluid() != null && tank.getFluid().getFluid() != ModFluids.FUELIUM) {
                            return false;
                        }
                        FluidStack fluidStack = handler.drain(50, true);
                        if (fluidStack != null && (remaining = jerryCan.fill(stack, fluidStack.amount)) > 0) {
                            fluidStack.amount = remaining;
                            handler.fill(fluidStack, true);
                        }
                    }
                }
            }
        }
        return true;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_175623_d(pos) && worldIn.func_175623_d(pos.func_177984_a());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_175656_a(pos.func_177984_a(), state.func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(true)));
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockGasPump) {
                worldIn.func_175698_g(pos.func_177977_b());
            }
        } else if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockGasPump) {
            worldIn.func_175698_g(pos.func_177984_a());
        }
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)TOP) != false ? 4 : 0);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta % 4))).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(meta / 4 > 0));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TOP});
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            return new TileEntityGasPump();
        }
        return new TileEntityGasPumpTank();
    }
}

