/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.gui;

import com.mrcrayfish.vehicle.common.container.ContainerFluidExtractor;
import com.mrcrayfish.vehicle.crafting.FluidExtract;
import com.mrcrayfish.vehicle.tileentity.TileEntityFluidExtractor;
import com.mrcrayfish.vehicle.util.FluidUtils;
import com.mrcrayfish.vehicle.util.RenderUtil;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class GuiFluidExtractor
extends GuiContainer {
    private static final ResourceLocation GUI = new ResourceLocation("vehicle:textures/gui/fluid_extractor.png");
    private IInventory playerInventory;
    private TileEntityFluidExtractor tileEntityFluidExtractor;

    public GuiFluidExtractor(IInventory playerInventory, TileEntityFluidExtractor tileEntityFluidExtractor) {
        super((Container)new ContainerFluidExtractor(playerInventory, tileEntityFluidExtractor));
        this.playerInventory = playerInventory;
        this.tileEntityFluidExtractor = tileEntityFluidExtractor;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.tileEntityFluidExtractor.getFluidStackTank() != null) {
            FluidStack stack = this.tileEntityFluidExtractor.getFluidStackTank();
            if (this.isMouseWithinRegion(startX + 127, startY + 14, 16, 59, mouseX, mouseY)) {
                if (stack.amount > 0) {
                    this.func_146283_a(Arrays.asList(stack.getLocalizedName(), TextFormatting.GRAY.toString() + this.tileEntityFluidExtractor.getFluidLevel() + "/" + 5000 + " mB"), mouseX, mouseY);
                } else {
                    this.func_146283_a(Collections.singletonList("No Fluid"), mouseX, mouseY);
                }
            }
        }
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = this.tileEntityFluidExtractor.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(s, 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(GUI);
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tileEntityFluidExtractor.getRemainingFuel() > 0) {
            int remainingFuel = (int)(14.0 * ((double)this.tileEntityFluidExtractor.getRemainingFuel() / (double)this.tileEntityFluidExtractor.getFuelMaxProgress()));
            this.func_73729_b(startX + 64, startY + 53 + 14 - remainingFuel, 176, 14 - remainingFuel, 14, remainingFuel + 1);
        }
        if (this.tileEntityFluidExtractor.getExtractionProgress() > 0) {
            int left = startX + 93 + 1;
            int top = startY + 34;
            int right = left + 23 - 1;
            int bottom = top + 16;
            FluidExtract fluidExtract = this.tileEntityFluidExtractor.getFluidExtractSource();
            int fluidColor = -1;
            if (fluidExtract != null) {
                fluidColor = 0xFF000000 | FluidUtils.getAverageFluidColor(fluidExtract.getFluid());
            }
            RenderUtil.drawGradientRectHorizontal(left, top, right, bottom, -1, fluidColor, this.field_73735_i);
            this.func_73729_b(startX + 93, startY + 34, 176, 14, 23, 16);
            double extractionPercentage = (double)this.tileEntityFluidExtractor.getExtractionProgress() / 600.0;
            int extractionProgress = (int)(22.0 * extractionPercentage + 1.0);
            this.func_73729_b(startX + 93 + extractionProgress, startY + 34, 93 + extractionProgress, 34, 23 - extractionProgress, 17);
        }
        this.drawFluidTank(this.tileEntityFluidExtractor.getFluidStackTank(), startX + 127, startY + 14, (double)this.tileEntityFluidExtractor.getFluidLevel() / 5000.0, 59);
    }

    private void drawFluidTank(FluidStack fluid, int x, int y, double level, int height) {
        FluidUtils.drawFluidTankInGUI(fluid, x, y, level, height);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI);
        this.func_73729_b(x, y, 176, 44, 16, 59);
    }

    private boolean isMouseWithinRegion(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }
}

