/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.vehicle;

import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.entity.vehicle.EntitySpeedBoat;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;

public class RenderSpeedBoat
extends AbstractRenderVehicle<EntitySpeedBoat> {
    @Override
    public void render(EntitySpeedBoat entity, float partialTicks) {
        this.renderDamagedPart(entity, SpecialModels.SPEED_BOAT_BODY.getModel());
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.215, (double)-0.125);
        GlStateManager.func_179114_b((float)-45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)0.02, (double)0.0);
        float wheelAngle = entity.prevWheelAngle + (entity.wheelAngle - entity.prevWheelAngle) * partialTicks;
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 15.0f;
        GlStateManager.func_179114_b((float)turnRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderUtil.renderModel(SpecialModels.GO_KART_STEERING_WHEEL.getModel(), ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
    }

    @Override
    public void applyPlayerModel(EntitySpeedBoat entity, EntityPlayer player, ModelPlayer model, float partialTicks) {
        model.field_178721_j.field_78795_f = (float)Math.toRadians(-85.0);
        model.field_178721_j.field_78796_g = (float)Math.toRadians(20.0);
        model.field_178722_k.field_78795_f = (float)Math.toRadians(-85.0);
        model.field_178722_k.field_78796_g = (float)Math.toRadians(-20.0);
        float wheelAngle = entity.prevWheelAngle + (entity.wheelAngle - entity.prevWheelAngle) * partialTicks;
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 6.0f;
        model.field_178723_h.field_78795_f = (float)Math.toRadians(-65.0f - turnRotation);
        model.field_178723_h.field_78796_g = (float)Math.toRadians(-7.0);
        model.field_178724_i.field_78795_f = (float)Math.toRadians(-65.0f + turnRotation);
        model.field_178724_i.field_78796_g = (float)Math.toRadians(7.0);
    }

    @Override
    public void applyPlayerRender(EntitySpeedBoat entity, EntityPlayer player, float partialTicks) {
        int index = entity.getSeatTracker().getSeatIndex(player.func_110124_au());
        if (index != -1) {
            VehicleProperties properties = entity.getProperties();
            Seat seat = properties.getSeats().get(index);
            Vec3d seatVec = seat.getPosition().func_72441_c(0.0, (double)(properties.getAxleOffset() + properties.getWheelOffset()), 0.0).func_186678_a(properties.getBodyPosition().getScale());
            seatVec = new Vec3d(-seatVec.field_72450_a, seatVec.field_72448_b, seatVec.field_72449_c);
            seatVec = seatVec.func_186678_a(0.0625);
            double scale = 1.0666666666666667;
            double offsetX = -seatVec.field_72450_a * scale;
            double offsetY = (seatVec.field_72448_b + player.func_70033_W()) * scale + 1.5;
            double offsetZ = seatVec.field_72449_c * scale;
            GlStateManager.func_179137_b((double)offsetX, (double)offsetY, (double)offsetZ);
            float currentSpeedNormal = (entity.prevCurrentSpeed + (entity.currentSpeed - entity.prevCurrentSpeed) * partialTicks) / entity.getMaxSpeed();
            float turnAngleNormal = (entity.prevTurnAngle + (entity.turnAngle - entity.prevTurnAngle) * partialTicks) / (float)entity.getMaxTurnAngle();
            GlStateManager.func_179114_b((float)(turnAngleNormal * currentSpeedNormal * 15.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(-8.0f * Math.min(1.0f, currentSpeedNormal)), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)(-offsetX), (double)(-offsetY), (double)(-offsetZ));
        }
    }

    @Override
    protected boolean shouldRenderFuelLid() {
        return false;
    }
}

