/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity;

import com.mrcrayfish.vehicle.VehicleMod;
import com.mrcrayfish.vehicle.client.render.Wheel;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageDrift;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class EntityLandVehicle
extends EntityPoweredVehicle {
    private static final DataParameter<Boolean> DRIFTING = EntityDataManager.func_187226_a(EntityLandVehicle.class, (DataSerializer)DataSerializers.field_187198_h);
    public float drifting;
    public float additionalYaw;
    public float prevAdditionalYaw;
    public float frontWheelRotation;
    public float prevFrontWheelRotation;
    public float rearWheelRotation;
    public float prevRearWheelRotation;

    public EntityLandVehicle(World worldIn) {
        super(worldIn);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DRIFTING, (Object)false);
    }

    @Override
    public void onUpdateVehicle() {
        super.onUpdateVehicle();
        this.updateWheels();
    }

    @Override
    public void updateVehicle() {
        this.prevAdditionalYaw = this.additionalYaw;
        this.prevFrontWheelRotation = this.frontWheelRotation;
        this.prevRearWheelRotation = this.rearWheelRotation;
        this.updateDrifting();
    }

    @Override
    public void onClientUpdate() {
        super.onClientUpdate();
        EntityLivingBase entity = (EntityLivingBase)this.func_184179_bs();
        if (entity != null && entity.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            boolean drifting = VehicleMod.proxy.isDrifting();
            if (this.isDrifting() != drifting) {
                this.setDrifting(drifting);
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageDrift(drifting));
            }
        }
    }

    @Override
    public void updateVehicleMotion() {
        float currentSpeed = this.currentSpeed;
        if (this.speedMultiplier > 1.0f) {
            this.speedMultiplier = 1.0f;
        }
        currentSpeed += currentSpeed * this.speedMultiplier;
        VehicleProperties properties = this.getProperties();
        if (properties.getFrontAxelVec() != null && properties.getRearAxelVec() != null) {
            EntityPoweredVehicle.AccelerationDirection acceleration = this.getAcceleration();
            if (acceleration == EntityPoweredVehicle.AccelerationDirection.CHARGING && this.charging) {
                PartPosition bodyPosition = properties.getBodyPosition();
                Vec3d frontAxel = properties.getFrontAxelVec().func_186678_a(0.0625).func_186678_a(bodyPosition.getScale());
                Vec3d nextFrontAxel = frontAxel.func_178785_b(this.turnAngle / 20.0f * ((float)Math.PI / 180));
                Vec3d deltaAxel = frontAxel.func_178788_d(nextFrontAxel).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                double deltaYaw = -this.turnAngle / 20.0f;
                this.field_70177_z = (float)((double)this.field_70177_z + deltaYaw);
                this.deltaYaw = (float)(-deltaYaw);
                this.vehicleMotionX = (float)deltaAxel.field_72450_a;
                if (!this.launching) {
                    this.field_70181_x -= 0.08;
                }
                this.vehicleMotionZ = (float)deltaAxel.field_72449_c;
                return;
            }
            PartPosition bodyPosition = properties.getBodyPosition();
            Vec3d nextFrontAxelVec = new Vec3d(0.0, 0.0, (double)(currentSpeed / 20.0f)).func_178785_b(this.wheelAngle * ((float)Math.PI / 180));
            nextFrontAxelVec = nextFrontAxelVec.func_178787_e(properties.getFrontAxelVec().func_186678_a(0.0625));
            Vec3d nextRearAxelVec = new Vec3d(0.0, 0.0, (double)(currentSpeed / 20.0f));
            nextRearAxelVec = nextRearAxelVec.func_178787_e(properties.getRearAxelVec().func_186678_a(0.0625));
            double deltaYaw = Math.toDegrees(Math.atan2(nextRearAxelVec.field_72449_c - nextFrontAxelVec.field_72449_c, nextRearAxelVec.field_72450_a - nextFrontAxelVec.field_72450_a)) + 90.0;
            if (this.isRearWheelSteering()) {
                deltaYaw -= 180.0;
            }
            this.field_70177_z = (float)((double)this.field_70177_z + deltaYaw);
            this.deltaYaw = (float)(-deltaYaw);
            Vec3d nextVehicleVec = nextFrontAxelVec.func_178787_e(nextRearAxelVec).func_186678_a(0.5);
            nextVehicleVec = nextVehicleVec.func_178788_d(properties.getFrontAxelVec().func_178787_e(properties.getRearAxelVec()).func_186678_a(0.0625).func_186678_a(0.5));
            nextVehicleVec = nextVehicleVec.func_186678_a(bodyPosition.getScale()).func_178785_b((-this.field_70177_z + 90.0f) * ((float)Math.PI / 180));
            float targetRotation = (float)Math.toDegrees(Math.atan2(nextVehicleVec.field_72449_c, nextVehicleVec.field_72450_a));
            float f1 = MathHelper.func_76126_a((float)(targetRotation * ((float)Math.PI / 180))) / 20.0f * (float)(currentSpeed > 0.0f ? 1 : -1);
            float f2 = MathHelper.func_76134_b((float)(targetRotation * ((float)Math.PI / 180))) / 20.0f * (float)(currentSpeed > 0.0f ? 1 : -1);
            this.vehicleMotionX = -currentSpeed * f1;
            if (!this.launching) {
                this.field_70181_x -= 0.08;
            }
            this.vehicleMotionZ = currentSpeed * f2;
        } else {
            float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) / 20.0f;
            float f2 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) / 20.0f;
            this.vehicleMotionX = -currentSpeed * f1;
            if (!this.launching) {
                this.field_70181_x -= 0.08;
            }
            this.vehicleMotionZ = currentSpeed * f2;
        }
    }

    @Override
    protected void updateTurning() {
        this.turnAngle = VehicleMod.proxy.getTargetTurnAngle(this, this.isDrifting());
        this.wheelAngle = this.turnAngle * Math.max(0.1f, 1.0f - Math.abs(this.currentSpeed / this.getMaxSpeed()));
        VehicleProperties properties = this.getProperties();
        if (properties.getFrontAxelVec() == null || properties.getRearAxelVec() == null) {
            this.deltaYaw = this.wheelAngle * (this.currentSpeed / 30.0f) / 2.0f;
        }
        if (this.field_70170_p.field_72995_K) {
            this.targetWheelAngle = this.isDrifting() ? -35.0f * (this.turnAngle / (float)this.getMaxTurnAngle()) * this.getNormalSpeed() : this.wheelAngle - 35.0f * (this.turnAngle / (float)this.getMaxTurnAngle()) * this.drifting;
            this.renderWheelAngle += (this.targetWheelAngle - this.renderWheelAngle) * (this.isDrifting() ? 0.35f : 0.5f);
        }
    }

    private void updateDrifting() {
        EntityPoweredVehicle.TurnDirection turnDirection = this.getTurnDirection();
        if (this.func_184179_bs() != null && this.isDrifting()) {
            if (turnDirection != EntityPoweredVehicle.TurnDirection.FORWARD) {
                EntityPoweredVehicle.AccelerationDirection acceleration = this.getAcceleration();
                if (acceleration == EntityPoweredVehicle.AccelerationDirection.FORWARD) {
                    this.currentSpeed *= 0.975f;
                }
                this.drifting = Math.min(1.0f, this.drifting + 0.025f);
            }
        } else {
            this.drifting *= 0.95f;
        }
        this.additionalYaw = 25.0f * this.drifting * (this.turnAngle / (float)this.getMaxTurnAngle()) * Math.min(this.getActualMaxSpeed(), this.getActualSpeed() * 2.0f);
        this.deltaYaw = this.wheelAngle * (this.currentSpeed / 30.0f) / (this.isDrifting() ? 1.5f : 2.0f);
    }

    public void updateWheels() {
        Wheel rearWheel;
        VehicleProperties properties = VehicleProperties.getProperties(((Object)((Object)this)).getClass());
        double wheelCircumference = 16.0;
        double vehicleScale = properties.getBodyPosition().getScale();
        double speed = this.getSpeed();
        Wheel frontWheel = properties.getFirstFrontWheel();
        if (frontWheel != null && !this.charging) {
            double frontWheelCircumference = wheelCircumference * vehicleScale * (double)frontWheel.getScaleY();
            double rotation = speed * 16.0 / frontWheelCircumference;
            this.frontWheelRotation = (float)((double)this.frontWheelRotation - rotation * 20.0);
        }
        if ((rearWheel = properties.getFirstRearWheel()) != null) {
            double rearWheelCircumference = wheelCircumference * vehicleScale * (double)rearWheel.getScaleY();
            double rotation = speed * 16.0 / rearWheelCircumference;
            this.rearWheelRotation = (float)((double)this.rearWheelRotation - rotation * 20.0);
        }
    }

    @Override
    public void createParticles() {
        if (this.canDrive()) {
            super.createParticles();
        }
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        if (this.func_184179_bs() == null) {
            this.field_70177_z -= this.additionalYaw;
            this.additionalYaw = 0.0f;
            this.drifting = 0.0f;
        }
    }

    public void setDrifting(boolean drifting) {
        this.field_70180_af.func_187227_b(DRIFTING, (Object)drifting);
    }

    public boolean isDrifting() {
        return (Boolean)this.field_70180_af.func_187225_a(DRIFTING);
    }

    @Override
    protected float getModifiedAccelerationSpeed() {
        if (this.trailer != null) {
            if (this.trailer.func_184188_bt().size() > 0) {
                return super.getModifiedAccelerationSpeed() * 0.5f;
            }
            return super.getModifiedAccelerationSpeed() * 0.8f;
        }
        return super.getModifiedAccelerationSpeed();
    }

    @Override
    public float getModifiedRotationYaw() {
        return this.field_70177_z - this.additionalYaw;
    }

    public boolean isRearWheelSteering() {
        VehicleProperties properties = this.getProperties();
        return properties.getFrontAxelVec() != null && properties.getRearAxelVec() != null && properties.getFrontAxelVec().field_72449_c < properties.getRearAxelVec().field_72449_c;
    }

    @Override
    protected boolean canCharge() {
        return true;
    }

    public boolean canWheelie() {
        return true;
    }
}

