/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.servers;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.ServerPinger;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ServerCache {
    private static final ThreadPoolExecutor EXECUTOR = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).build());
    protected static GuiMultiplayer guiMultiplayer = new GuiMultiplayer(null);
    protected static ServerPinger pinger = guiMultiplayer.func_146789_i();
    protected static GuiScreen lastScreen = null;
    protected static Map<String, ServerData> servers = new HashMap<String, ServerData>();

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ServerCache());
        new Thread(() -> {
            while (true) {
                try {
                    if (Minecraft.func_71410_x().field_71462_r != null && MenuCustomization.isMenuCustomizable(Minecraft.func_71410_x().field_71462_r)) {
                        ServerCache.pingServers();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Thread.sleep(30000L);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }).start();
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post e) {
        if (lastScreen != Minecraft.func_71410_x().field_71462_r) {
            new Thread(() -> {
                try {
                    ServerCache.pingServers();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
        }
        lastScreen = Minecraft.func_71410_x().field_71462_r;
        pinger.func_147223_a();
    }

    public static void cacheServer(ServerData server) {
        if (server.field_78845_b != null) {
            try {
                server.field_78844_e = -1L;
                servers.put(server.field_78845_b, server);
                ServerCache.pingServers();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static ServerData getServer(String ip) {
        if (!servers.containsKey(ip)) {
            ServerCache.cacheServer(new ServerData(ip, ip, false));
        }
        return servers.get(ip);
    }

    public static void removeServer(String ip) {
        servers.remove(ip);
    }

    public static void clear() {
        servers.clear();
    }

    public static void pingServers() {
        ArrayList<ServerData> l = new ArrayList<ServerData>();
        l.addAll(servers.values());
        for (ServerData d : l) {
            try {
                new Thread(() -> {
                    try {
                        ServerCache.pingServer(d);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }).start();
            }
            catch (Exception exception) {}
        }
    }

    protected static void pingServer(final ServerData server) {
        if (server != null) {
            try {
                long curTime;
                Minecraft mc = Minecraft.func_71410_x();
                if (!server.field_78841_f) {
                    server.field_78841_f = true;
                    server.field_78844_e = -2L;
                    server.field_78843_d = "";
                    server.field_78846_c = "";
                    EXECUTOR.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                pinger.func_147224_a(server);
                            }
                            catch (UnknownHostException var2) {
                                server.field_78844_e = -1L;
                                server.field_78843_d = TextFormatting.DARK_RED + I18n.func_135052_a((String)"multiplayer.status.cannot_resolve", (Object[])new Object[0]);
                            }
                            catch (Exception var3) {
                                server.field_78844_e = -1L;
                                server.field_78843_d = TextFormatting.DARK_RED + I18n.func_135052_a((String)"multiplayer.status.cannot_connect", (Object[])new Object[0]);
                            }
                        }
                    });
                }
                long startTime = System.currentTimeMillis();
                while (!(startTime + 15000L <= (curTime = System.currentTimeMillis()) || server.field_78841_f && server.field_78844_e != -2L)) {
                    Thread.sleep(100L);
                }
                server.field_78841_f = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

