/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.slideshow;

import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.properties.PropertiesSerializer;
import de.keksuccino.konkrete.properties.PropertiesSet;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class ExternalTextureSlideshowRenderer
extends Gui {
    protected List<ExternalTextureResourceLocation> images = new ArrayList<ExternalTextureResourceLocation>();
    protected ExternalTextureResourceLocation overlay_texture;
    protected String name = null;
    public String dir;
    protected boolean prepared = false;
    protected double imageDuration = 10.0;
    protected float fadeSpeed = 1.0f;
    public int width = 50;
    public int height = 50;
    public int x = 0;
    public int y = 0;
    protected float opacity = 1.0f;
    protected int imageTick = -1;
    protected long opacityTick = -1L;
    protected long lastChange = -1L;
    protected boolean firstLoop = true;
    public float slideshowOpacity = 1.0f;
    protected ExternalTextureResourceLocation previous;
    protected ExternalTextureResourceLocation current;

    public ExternalTextureSlideshowRenderer(String slideshowDir) {
        this.dir = slideshowDir;
        File props = new File(this.dir + "/properties.txt");
        if (props.exists()) {
            PropertiesSet s = PropertiesSerializer.getProperties((String)props.getPath());
            if (s != null) {
                List l = s.getPropertiesOfType("slideshow-meta");
                if (l != null && !l.isEmpty()) {
                    String sh;
                    String sw;
                    String sy;
                    String sx;
                    String fs;
                    String dur;
                    this.name = ((PropertiesSection)l.get(0)).getEntryValue("name");
                    if (this.name == null) {
                        System.out.println("############## ERROR [FANCYMENU] ##############");
                        System.out.println("Missing 'name' value in properties file for slideshow: " + this.dir);
                        System.out.println("###############################################");
                    }
                    if ((dur = ((PropertiesSection)l.get(0)).getEntryValue("duration")) != null && MathUtils.isDouble((String)dur)) {
                        this.imageDuration = Double.parseDouble(dur);
                    }
                    if ((fs = ((PropertiesSection)l.get(0)).getEntryValue("fadespeed")) != null && MathUtils.isFloat((String)fs)) {
                        float f = Float.parseFloat(fs);
                        if (f < 0.0f) {
                            f = 0.0f;
                        }
                        this.fadeSpeed = f;
                    }
                    if ((sx = ((PropertiesSection)l.get(0)).getEntryValue("x")) != null && MathUtils.isInteger((String)sx)) {
                        this.x = Integer.parseInt(sx);
                    }
                    if ((sy = ((PropertiesSection)l.get(0)).getEntryValue("y")) != null && MathUtils.isInteger((String)sy)) {
                        this.y = Integer.parseInt(sy);
                    }
                    if ((sw = ((PropertiesSection)l.get(0)).getEntryValue("width")) != null && MathUtils.isInteger((String)sw)) {
                        this.width = Integer.parseInt(sw);
                    }
                    if ((sh = ((PropertiesSection)l.get(0)).getEntryValue("height")) != null && MathUtils.isInteger((String)sh)) {
                        this.height = Integer.parseInt(sh);
                    }
                } else {
                    System.out.println("############## ERROR [FANCYMENU] ##############");
                    System.out.println("Missing 'slideshow-meta' section in properties file for slideshow: " + this.dir);
                    System.out.println("###############################################");
                }
            } else {
                System.out.println("############## ERROR [FANCYMENU] ##############");
                System.out.println("An error happened while trying to get properties for slideshow: " + this.dir);
                System.out.println("###############################################");
            }
        } else {
            System.out.println("############## ERROR [FANCYMENU] ##############");
            System.out.println("Properties file not found for slideshow: " + this.dir);
            System.out.println("###############################################");
        }
    }

    public void prepareSlideshow() {
        File imagesDir;
        if (!this.prepared && this.name != null && (imagesDir = new File(this.dir + "/images")).exists() && imagesDir.isDirectory()) {
            String[] list = imagesDir.list();
            List<String> images = Arrays.asList(list);
            if (!images.isEmpty()) {
                Collections.sort(images, String.CASE_INSENSITIVE_ORDER);
                for (String s : images) {
                    File f = new File(imagesDir.getPath() + "/" + s);
                    if (!f.exists() || !f.isFile() || !f.getPath().toLowerCase().endsWith(".jpg") && !f.getPath().toLowerCase().endsWith(".png")) continue;
                    ExternalTextureResourceLocation r = new ExternalTextureResourceLocation(f.getPath());
                    this.images.add(r);
                }
                File overlay = new File(this.dir + "/overlay.png");
                if (overlay.exists()) {
                    this.overlay_texture = new ExternalTextureResourceLocation(overlay.getPath());
                }
            }
            this.prepared = true;
        }
    }

    public void render() {
        try {
            if (!this.images.isEmpty()) {
                this.tick();
                this.renderCurrent();
                this.renderPrevious();
                this.renderOverlay();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void tick() {
        if (!this.images.isEmpty()) {
            long time = System.currentTimeMillis();
            long duration = (long)(1000.0 * this.imageDuration);
            long opacityTickSpeed = 25L;
            if (this.firstLoop) {
                duration /= 2L;
            }
            if (this.previous == null && this.lastChange + duration < time) {
                ++this.imageTick;
                if (this.imageTick > this.images.size() - 1) {
                    this.imageTick = 0;
                }
                this.lastChange = time;
                this.opacity = 1.0f;
                this.previous = this.current;
                this.current = this.images.get(this.imageTick);
            }
            if (this.previous != null && this.opacity > 0.0f) {
                this.firstLoop = false;
                if (this.opacityTick + opacityTickSpeed < time) {
                    this.opacityTick = time;
                    this.opacity -= 0.005f * this.fadeSpeed;
                    if (this.opacity < 0.0f) {
                        this.opacity = 0.0f;
                    }
                }
            } else {
                this.previous = null;
            }
        }
    }

    protected void renderPrevious() {
        if (this.previous != null && this.current != this.previous) {
            if (!this.previous.isReady()) {
                this.previous.loadTexture();
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            float o = this.opacity;
            if (o > this.slideshowOpacity) {
                o = this.slideshowOpacity;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)o);
            ResourceLocation r = this.previous.getResourceLocation();
            if (r != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(r);
                ExternalTextureSlideshowRenderer.func_146110_a((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (float)this.width, (float)this.height);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    protected void renderCurrent() {
        if (this.current != null) {
            if (!this.current.isReady()) {
                this.current.loadTexture();
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.slideshowOpacity);
            ResourceLocation r = this.current.getResourceLocation();
            if (r != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(r);
                ExternalTextureSlideshowRenderer.func_146110_a((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (float)this.width, (float)this.height);
            }
        }
    }

    protected void renderOverlay() {
        if (this.overlay_texture != null) {
            if (!this.overlay_texture.isReady()) {
                this.overlay_texture.loadTexture();
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ResourceLocation r = this.overlay_texture.getResourceLocation();
            if (r != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(r);
                ExternalTextureSlideshowRenderer.func_146110_a((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (float)this.width, (float)this.height);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setDuration(double duration) {
        this.imageDuration = duration;
    }

    public void setFadeSpeed(float speed) {
        if (speed < 0.0f) {
            speed = 0.0f;
        }
        this.fadeSpeed = speed;
    }

    public boolean isReady() {
        return this.prepared;
    }
}

