/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.net.MessageToServer;
import de.maxhenkel.camera.proxy.CommonProxy;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;

public class MessagePartialImage
extends MessageToServer<MessagePartialImage> {
    private UUID imgUUID;
    private int offset;
    private int length;
    private byte[] bytes;

    public MessagePartialImage() {
    }

    public MessagePartialImage(UUID imgUUID, int offset, int length, byte[] bytes) {
        this.imgUUID = imgUUID;
        this.offset = offset;
        this.length = length;
        this.bytes = bytes;
    }

    @Override
    public void execute(EntityPlayerMP player, MessagePartialImage message) {
        CommonProxy.packetManager.addBytes(player, message.imgUUID, message.offset, message.length, message.bytes);
    }

    public void fromBytes(ByteBuf buf) {
        long l1 = buf.readLong();
        long l2 = buf.readLong();
        this.imgUUID = new UUID(l1, l2);
        this.offset = buf.readInt();
        this.length = buf.readInt();
        int length = buf.readInt();
        this.bytes = new byte[length];
        buf.readBytes(this.bytes);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.imgUUID.getMostSignificantBits());
        buf.writeLong(this.imgUUID.getLeastSignificantBits());
        buf.writeInt(this.offset);
        buf.writeInt(this.length);
        buf.writeInt(this.bytes.length);
        buf.writeBytes(this.bytes);
    }
}

