/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui;

import de.keksuccino.fancymenu.menu.fancy.helper.ui.ScrollableScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.localization.Locals;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;

public class ChooseFromStringListScreen
extends ScrollableScreen {
    protected Consumer<String> callback;
    protected List<String> parentList = new ArrayList<String>();
    protected AdvancedButton backButton;

    public ChooseFromStringListScreen(String screenTitle, GuiScreen parentScreen, List<String> parentList, Consumer<String> callback) {
        super(parentScreen, screenTitle);
        this.callback = callback;
        if (parentList != null) {
            this.parentList = parentList;
        }
        this.backButton = new AdvancedButton(0, 0, 200, 20, Locals.localize((String)"fancymenu.guicomponents.back", (String[])new String[0]), true, press -> {
            this.onCancel();
            Minecraft.func_71410_x().func_147108_a(this.parent);
        });
        UIBase.colorizeButton(this.backButton);
        for (String s : this.parentList) {
            this.scrollArea.addEntry((ScrollAreaEntry)new StringScrollAreaEntry(this.scrollArea, s, this));
        }
    }

    protected void onCancel() {
        if (this.callback != null) {
            this.callback.accept(null);
        }
    }

    @Override
    public void closeScreen() {
        this.onCancel();
        Minecraft.func_71410_x().func_147108_a(this.parent);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int xCenter = this.field_146294_l / 2;
        this.backButton.field_146128_h = xCenter - this.backButton.field_146120_f / 2;
        this.backButton.field_146129_i = this.field_146295_m - 35;
        this.backButton.func_191745_a(Minecraft.func_71410_x(), mouseX, mouseY, partialTicks);
    }

    public static class StringScrollAreaEntry
    extends ScrollAreaEntry {
        protected String entryValue;
        protected FontRenderer font;
        protected ChooseFromStringListScreen parentScreen;
        protected boolean isMouseDown;

        public StringScrollAreaEntry(ScrollArea parent, String entryValue, ChooseFromStringListScreen parentScreen) {
            super(parent);
            this.font = Minecraft.func_71410_x().field_71466_p;
            this.isMouseDown = false;
            this.entryValue = entryValue;
            this.parentScreen = parentScreen;
        }

        public void renderEntry() {
            int center = this.x + this.getWidth() / 2;
            if (!this.isHovered()) {
                StringScrollAreaEntry.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)ScrollableScreen.ENTRY_BACKGROUND_COLOR.getRGB());
            } else {
                StringScrollAreaEntry.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)ScrollableScreen.ENTRY_BACKGROUND_COLOR.brighter().brighter().getRGB());
            }
            String value = this.entryValue;
            if (this.font.func_78256_a(value) > this.getWidth() - 30) {
                value = new StringBuilder(value).reverse().toString();
                value = this.font.func_78269_a(value, this.getWidth() - 30);
                value = new StringBuilder(value).reverse().toString();
                value = ".." + value;
            }
            this.func_73732_a(this.font, value, center, this.y + 10, -1);
            this.handleSelection();
        }

        protected void handleSelection() {
            if (!PopupHandler.isPopupActive() && !this.parentScreen.backButton.func_146115_a()) {
                if (MouseInput.isLeftMouseDown() && !this.isMouseDown) {
                    if (this.isHovered() && this.parentScreen.callback != null) {
                        this.parentScreen.callback.accept(this.entryValue);
                    }
                    this.isMouseDown = true;
                }
                if (!MouseInput.isLeftMouseDown()) {
                    this.isMouseDown = false;
                }
            } else if (MouseInput.isLeftMouseDown()) {
                this.isMouseDown = true;
            }
        }

        public int getHeight() {
            return 26;
        }
    }
}

