/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui;

import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;

public class ScrollableScreen
extends GuiScreen {
    protected static final Color ENTRY_BACKGROUND_COLOR = new Color(92, 92, 92);
    protected static final Color SCREEN_BACKGROUND_COLOR = new Color(54, 54, 54);
    protected static final Color HEADER_FOOTER_COLOR = new Color(33, 33, 33);
    protected ScrollArea scrollArea;
    protected GuiScreen parent;
    protected String title;

    public ScrollableScreen(GuiScreen parent, String title) {
        this.parent = parent;
        this.title = title;
        this.scrollArea = new ScrollArea(0, 50, 300, 0);
        this.scrollArea.backgroundColor = ENTRY_BACKGROUND_COLOR;
    }

    public void func_73866_w_() {
        this.scrollArea.x = this.field_146294_l / 2 - 150;
        this.scrollArea.height = this.field_146295_m - 100;
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (!PopupHandler.isPopupActive() && keyCode == 1) {
            this.closeScreen();
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        }
    }

    public void closeScreen() {
        this.field_146297_k.func_147108_a(this.parent);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179147_l();
        ScrollableScreen.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)SCREEN_BACKGROUND_COLOR.getRGB());
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            if (!(e instanceof ScrollAreaEntryBase)) continue;
            ((ScrollAreaEntryBase)e).isOverlayButtonHovered = this.isOverlayButtonHovered();
        }
        this.scrollArea.render();
        ScrollableScreen.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)50, (int)HEADER_FOOTER_COLOR.getRGB());
        this.func_73732_a(Minecraft.func_71410_x().field_71466_p, this.title, this.field_146294_l / 2, 20, -1);
        ScrollableScreen.func_73734_a((int)0, (int)(this.field_146295_m - 50), (int)this.field_146294_l, (int)this.field_146295_m, (int)HEADER_FOOTER_COLOR.getRGB());
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            if (!(e instanceof ScrollAreaEntryBase) || !((ScrollAreaEntryBase)e).isOverlayButtonHoveredAndOverlapsArea() || ((ScrollAreaEntryBase)e).description == null) continue;
            ScrollableScreen.renderDescription(((ScrollAreaEntryBase)e).description, MouseInput.getMouseX(), MouseInput.getMouseY());
            break;
        }
    }

    protected static void renderDescription(List<String> desc, int mouseX, int mouseY) {
        if (desc != null) {
            int width = 10;
            int height = 10;
            for (String s : desc) {
                int i = Minecraft.func_71410_x().field_71466_p.func_78256_a(s) + 10;
                if (i > width) {
                    width = i;
                }
                height += 10;
            }
            mouseY += 5;
            if (Minecraft.func_71410_x().field_71462_r.field_146294_l < (mouseX += 5) + width) {
                mouseX -= width + 10;
            }
            if (Minecraft.func_71410_x().field_71462_r.field_146295_m < mouseY + height) {
                mouseY -= height + 10;
            }
            RenderUtils.setZLevelPre((int)600);
            ScrollableScreen.renderDescriptionBackground(mouseX, mouseY, width, height);
            GlStateManager.func_179147_l();
            int i2 = 5;
            for (String s : desc) {
                Minecraft.func_71410_x().field_71462_r.func_73731_b(Minecraft.func_71410_x().field_71466_p, s, mouseX + 5, mouseY + i2, Color.WHITE.getRGB());
                i2 += 10;
            }
            RenderUtils.setZLevelPost();
            GlStateManager.func_179084_k();
        }
    }

    protected static void renderDescriptionBackground(int x, int y, int width, int height) {
        ScrollableScreen.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)new Color(26, 26, 26, 250).getRGB());
    }

    public boolean isOverlayButtonHovered() {
        return false;
    }

    public static class SeparatorEntry
    extends ScrollAreaEntryBase {
        public SeparatorEntry(ScrollArea parent, int height, Color color) {
            super(parent, null);
            this.renderBody = render -> SeparatorEntry.func_73734_a((int)render.entry.x, (int)render.entry.y, (int)(render.entry.x + render.entry.getWidth()), (int)(render.entry.y + render.entry.getHeight()), (int)color.getRGB());
            this.setHeight(height);
        }
    }

    public static class EmptySpaceEntry
    extends ScrollAreaEntryBase {
        public EmptySpaceEntry(ScrollArea parent, int height) {
            super(parent, null);
            this.renderBody = render -> {};
            this.setHeight(height);
        }
    }

    public static class TextEntry
    extends ScrollAreaEntryBase {
        public String text;
        public boolean bold;

        public TextEntry(ScrollArea parent, String text, boolean bold) {
            super(parent, null);
            this.text = text;
            this.bold = bold;
            this.renderBody = render -> {
                if (this.text != null) {
                    FontRenderer font = Minecraft.func_71410_x().field_71466_p;
                    int xCenter = render.entry.x + render.entry.getWidth() / 2;
                    int yCenter = render.entry.y + render.entry.getHeight() / 2;
                    String s = this.text;
                    if (this.bold) {
                        s = "\u00a7l" + this.text;
                    }
                    this.func_73732_a(font, s, xCenter, yCenter - font.field_78288_b / 2, -1);
                }
            };
            this.setHeight(18);
        }
    }

    public static class TextFieldEntry
    extends ScrollAreaEntryBase {
        public AdvancedTextField textField;

        public TextFieldEntry(ScrollArea parent, AdvancedTextField textField) {
            super(parent, null);
            this.textField = textField;
            this.textField.func_146203_f(10000);
            this.renderBody = render -> {
                int xCenter = render.entry.x + render.entry.getWidth() / 2;
                if (!this.isOverlayButtonHoveredAndOverlapsArea()) {
                    this.textField.func_146184_c(true);
                } else {
                    this.textField.func_146184_c(false);
                }
                this.textField.field_146218_h = 200;
                this.textField.field_146219_i = 20;
                this.textField.field_146209_f = xCenter - this.textField.func_146200_o() / 2;
                this.textField.field_146210_g = render.entry.y + 2;
                this.textField.func_146194_f();
            };
            this.setHeight(24);
        }
    }

    public static class ButtonEntry
    extends ScrollAreaEntryBase {
        public AdvancedButton button;

        public ButtonEntry(ScrollArea parent, AdvancedButton button) {
            super(parent, null);
            this.button = button;
            this.renderBody = render -> {
                int xCenter = render.entry.x + render.entry.getWidth() / 2;
                UIBase.colorizeButton(this.button);
                this.button.field_146124_l = !this.isOverlayButtonHoveredAndOverlapsArea();
                this.button.field_146120_f = 200;
                this.button.field_146121_g = 20;
                this.button.field_146128_h = xCenter - this.button.field_146120_f / 2;
                this.button.field_146129_i = render.entry.y + 2;
                this.button.func_191745_a(Minecraft.func_71410_x(), MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.func_71410_x().func_193989_ak());
            };
            this.setHeight(24);
        }
    }

    public static class ScrollAreaEntryBase
    extends ScrollAreaEntry {
        protected int entryHeight = 25;
        protected List<String> description = null;
        protected Consumer<EntryRenderCallback> renderBody;
        protected boolean isOverlayButtonHovered = false;

        public ScrollAreaEntryBase(ScrollArea parent, Consumer<EntryRenderCallback> renderBody) {
            super(parent);
            this.renderBody = renderBody;
        }

        public void renderEntry() {
            EntryRenderCallback c = new EntryRenderCallback();
            c.entry = this;
            this.renderBody.accept(c);
        }

        public int getHeight() {
            return this.entryHeight;
        }

        public void setHeight(int height) {
            this.entryHeight = height;
        }

        public List<String> getDescription() {
            return this.description;
        }

        public boolean isOverlayButtonHoveredAndOverlapsArea() {
            return this.isOverlayButtonHovered && this.isHovered();
        }

        public void setDescription(List<String> desc) {
            this.description = desc;
        }

        public void setDescription(String[] desc) {
            this.description = Arrays.asList(desc);
        }

        public static class EntryRenderCallback {
            public ScrollAreaEntryBase entry;
        }
    }
}

