<?php
header('Content-Type: application/json');
include('../class/include.php');
if (!Account::isAuthentified() || !CSRF::isAjaxRequest())
{
    die("Bad request");
}

$all_server_predata = Server::GetAllServer();
$list = [];

foreach ($all_server_predata as $data)
{
	if ($data['last_update'] + 20 < time())
	{
	    $button_delete = '<button style="padding: 0; border: none; background: none; color: gray;" onclick="deleteServer('.$data['id'].')">
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-x-circle"><circle cx="12" cy="12" r="10"></circle><line x1="15" y1="9" x2="9" y2="15"></line><line x1="9" y1="9" x2="15" y2="15"></line></svg></button>';

	    if($data['server_rcon'] !== "Pas de RCON") {
	    	$button_rcon = '<button style="padding: 0; border: none; background: none; color: gray;" onclick="rconreconnect('.$data['id'].')" >
<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-rss"><path d="M4 11a9 9 0 0 1 9 9"></path><path d="M4 4a16 16 0 0 1 16 16"></path><circle cx="5" cy="19" r="1"></circle></svg></button>';
	    } else {
	    	$button_rcon = '';
	    }

	    $ip_data = explode(':', $data['server_ip']);

	    array_push($list, ["DT_RowId" => "server-".$data['id'], $data['server_name'], $ip_data[0], $ip_data[1], $data['server_users'], date('d/m/Y à H:i:s', $data['last_update']), $button_rcon."&nbsp;".$button_delete]);
	}
}

echo json_encode(['data' => $list]);
?>
