$('#block-page').on('click', function() {
    $.blockUI({
        message: '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-loader spin"><line x1="12" y1="2" x2="12" y2="6"></line><line x1="12" y1="18" x2="12" y2="22"></line><line x1="4.93" y1="4.93" x2="7.76" y2="7.76"></line><line x1="16.24" y1="16.24" x2="19.07" y2="19.07"></line><line x1="2" y1="12" x2="6" y2="12"></line><line x1="18" y1="12" x2="22" y2="12"></line><line x1="4.93" y1="19.07" x2="7.76" y2="16.24"></line><line x1="16.24" y1="7.76" x2="19.07" y2="4.93"></line></svg>',
        fadeIn: 800, 
        timeout: 2000, //unblock after 2 seconds
        overlayCSS: {
            backgroundColor: '#191e3a',
            opacity: 0.8,
            zIndex: 1200,
            cursor: 'wait'
        },
        css: {
            border: 0,
            color: '#25d5e4',
            zIndex: 1201,
            padding: 0,
            backgroundColor: 'transparent'
        }
    });
});


$('#block-content').on('click', function() {
    var block = $('#reload');
    $(block).block({ 
        message: '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-loader spin"><line x1="12" y1="2" x2="12" y2="6"></line><line x1="12" y1="18" x2="12" y2="22"></line><line x1="4.93" y1="4.93" x2="7.76" y2="7.76"></line><line x1="16.24" y1="16.24" x2="19.07" y2="19.07"></line><line x1="2" y1="12" x2="6" y2="12"></line><line x1="18" y1="12" x2="22" y2="12"></line><line x1="4.93" y1="19.07" x2="7.76" y2="16.24"></line><line x1="16.24" y1="7.76" x2="19.07" y2="4.93"></line></svg>',
        timeout: 2000, //unblock after 2 seconds
        overlayCSS: {
            backgroundColor: '#191e3a',
            opacity: 0.8,
            cursor: 'wait'
        },
        css: {
            border: 0,
            color: '#25d5e4',
            padding: 0,
            backgroundColor: 'transparent'
        }
    });
});

// Growl notification
$('#block-growl').on('click', function() {
    $.blockUI({
        message: $('.blockui-growl-message'), 
        fadeIn: 700, 
        fadeOut: 700, 
        timeout: 3000, //unblock after 3 seconds
        showOverlay: false, 
        centerY: false, 
        css: { 
            width: '250px',
            backgroundColor: 'transparent',
            top: '20px',
            left: 'auto',
            right: '20px',
            border: 0,
            opacity: .95,
            zIndex: 1200,
        } 
    }); 
});

// Custom message position
$('#message-position').on('click', function() {
    var block = $('#m-s-reload');
    $(block).block({ 
        message: '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-loader spin"><line x1="12" y1="2" x2="12" y2="6"></line><line x1="12" y1="18" x2="12" y2="22"></line><line x1="4.93" y1="4.93" x2="7.76" y2="7.76"></line><line x1="16.24" y1="16.24" x2="19.07" y2="19.07"></line><line x1="2" y1="12" x2="6" y2="12"></line><line x1="18" y1="12" x2="22" y2="12"></line><line x1="4.93" y1="19.07" x2="7.76" y2="16.24"></line><line x1="16.24" y1="7.76" x2="19.07" y2="4.93"></line></svg>',
        timeout: 2000, //unblock after 2 seconds
        centerX: 0,
        centerY: 0,
        overlayCSS: {
            backgroundColor: '#191e3a',
            opacity: 0.8,
            cursor: 'wait'
        },
        css: {
            width: 35,
            top: '15px',
            left: '',
            right: '10px',
            bottom: 0,
            color: '#25d5e4',
            border: 0,
            padding: 0,
            backgroundColor: 'transparent'
        }
    });
});


// Auto unblock
$('#auto-unblock').on('click', function() {
    var block = $('#a-u-reload');
    $(block).block({
        message: '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-loader spin"><line x1="12" y1="2" x2="12" y2="6"></line><line x1="12" y1="18" x2="12" y2="22"></line><line x1="4.93" y1="4.93" x2="7.76" y2="7.76"></line><line x1="16.24" y1="16.24" x2="19.07" y2="19.07"></line><line x1="2" y1="12" x2="6" y2="12"></line><line x1="18" y1="12" x2="22" y2="12"></line><line x1="4.93" y1="19.07" x2="7.76" y2="16.24"></line><line x1="16.24" y1="7.76" x2="19.07" y2="4.93"></line></svg>',
        timeout: 2000, //unblock after 2 seconds
        overlayCSS: {
            backgroundColor: '#191e3a',
            opacity: 0.8,
            cursor: 'wait'
        },
        css: {
            border: 0,
            padding: 0,
            color: '#25d5e4',
            backgroundColor: 'transparent'
        }
    });
});

// Block callback
$('#block-callback').on('click', function() {
    $.blockUI({
        message: '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-loader spin"><line x1="12" y1="2" x2="12" y2="6"></line><line x1="12" y1="18" x2="12" y2="22"></line><line x1="4.93" y1="4.93" x2="7.76" y2="7.76"></line><line x1="16.24" y1="16.24" x2="19.07" y2="19.07"></line><line x1="2" y1="12" x2="6" y2="12"></line><line x1="18" y1="12" x2="22" y2="12"></line><line x1="4.93" y1="19.07" x2="7.76" y2="16.24"></line><line x1="16.24" y1="7.76" x2="19.07" y2="4.93"></line></svg>',
        fadeIn: 800, 
        timeout: 2000, //unblock after 2 seconds
        overlayCSS: {
            backgroundColor: '#191e3a',
            opacity: 0.8,
            zIndex: 1200,
            cursor: 'wait'
        },
        css: {
            border: 0,
            color: '#25d5e4',
            zIndex: 1201,
            padding: 0,
            backgroundColor: 'transparent'
        },
        onBlock: function() {
            alert('Page is now blocked. FadeIn completed.'); 
        } 
    });
});

// Default message
$('#default-message').on('click', function() {
    var block = $('#d-t-reload');
    $(block).block({
        message: '<span class="text-semibold">Please wait...</span>',
        timeout: 2000, //unblock after 2 seconds
        overlayCSS: {
            backgroundColor: '#191e3a',
            opacity: 0.8,
            cursor: 'wait'
        },
        css: {
            border: 0,
            padding: 0,
            color: '#25d5e4',
            backgroundColor: 'transparent'
        }
    });
});



// Custom message animation
$('#message-animation').on('click', function() {
    var block = $(this).parent();
    $(block).block({
        message: $('.blockui-animation-container'),
        timeout: 3000, //unblock after 3 seconds
        overlayCSS: {
            backgroundColor: '#191e3a',
            opacity: 0.8,
            cursor: 'wait'
        },
        css: {
            width: 36,
            height: 36,
            color: '#25d5e4',
            border: 0,
            padding: 0,
            backgroundColor: 'transparent'
        }
    });

    var animation = $(this).data("animation");
    $('.blockui-animation-container').addClass("animated " + animation).one("webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend", function () {
        $(this).removeClass("animated " + animation);
    });
});

// Modal Blockui
$('#modal-blockui').on('click', function() {
    var block = $('#modal-reload');
    $(block).block({ 
        message: '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-loader spin"><line x1="12" y1="2" x2="12" y2="6"></line><line x1="12" y1="18" x2="12" y2="22"></line><line x1="4.93" y1="4.93" x2="7.76" y2="7.76"></line><line x1="16.24" y1="16.24" x2="19.07" y2="19.07"></line><line x1="2" y1="12" x2="6" y2="12"></line><line x1="18" y1="12" x2="22" y2="12"></line><line x1="4.93" y1="19.07" x2="7.76" y2="16.24"></line><line x1="16.24" y1="7.76" x2="19.07" y2="4.93"></line></svg>',
        showOverlay: false,
        timeout: 2000, //unblock after 2 seconds
        css: {
            border: 0,
            color: '#25d5e4',
            padding: 0,
            backgroundColor: 'transparent'
        }
    });
});


// Custom Overlay
$('#overlay-custom').on('click', function() {
    var block = $('#custom-overlay');
    $(block).block({ 
        message: '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-loader spin"><line x1="12" y1="2" x2="12" y2="6"></line><line x1="12" y1="18" x2="12" y2="22"></line><line x1="4.93" y1="4.93" x2="7.76" y2="7.76"></line><line x1="16.24" y1="16.24" x2="19.07" y2="19.07"></line><line x1="2" y1="12" x2="6" y2="12"></line><line x1="18" y1="12" x2="22" y2="12"></line><line x1="4.93" y1="19.07" x2="7.76" y2="16.24"></line><line x1="16.24" y1="7.76" x2="19.07" y2="4.93"></line></svg>',
        timeout: 2000, //unblock after 2 seconds
        overlayCSS: {
            backgroundColor: '#515365',
            opacity: 0.9,
            cursor: 'wait'
        },
        css: {
            border: 0,
            padding: 0,
            color: '#fff',
            backgroundColor: 'transparent'
        }
    });
});

// Custom message
$('#custom-message').on('click', function() {
    var block = $('#c-style');
    $(block).block({
        message: '<span class="text-semibold"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-loader spin position-left"><line x1="12" y1="2" x2="12" y2="6"></line><line x1="12" y1="18" x2="12" y2="22"></line><line x1="4.93" y1="4.93" x2="7.76" y2="7.76"></line><line x1="16.24" y1="16.24" x2="19.07" y2="19.07"></line><line x1="2" y1="12" x2="6" y2="12"></line><line x1="18" y1="12" x2="22" y2="12"></line><line x1="4.93" y1="19.07" x2="7.76" y2="16.24"></line><line x1="16.24" y1="7.76" x2="19.07" y2="4.93"></line></svg></i>&nbsp; Updating data</span>',
        timeout: 2000, //unblock after 2 seconds
        overlayCSS: {
            backgroundColor: '#191e3a',
            opacity: 1,
            cursor: 'wait'
        },
        css: {
            border: 0,
            padding: '10px 15px',
            color: '#0e1726',
            width: 'auto',
            '-webkit-border-radius': 2,
            '-moz-border-radius': 2,
            backgroundColor: '#009688'
        }
    });
});

// Multiple messages
$('#multiple-messages').on('click', function() {
    var message = $(this).next('.multiMessageBlockUi');
    var block = $(this).parent();
    $(block).block({ 
        message: message,
        overlayCSS: {
            backgroundColor: '#191e3a',
            opacity: 0.8,
            cursor: 'wait'
        },
        css: {
            width: 100,
            '-webkit-border-radius': 2,
            '-moz-border-radius': 2,
            border: 0,
            padding: 0,
            backgroundColor: 'transparent'
        },
        onBlock: function(){
            clearTimeout();
        }
    });

    window.setTimeout(function () {
       message.html('<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-loader spin"><line x1="12" y1="2" x2="12" y2="6"></line><line x1="12" y1="18" x2="12" y2="22"></line><line x1="4.93" y1="4.93" x2="7.76" y2="7.76"></line><line x1="16.24" y1="16.24" x2="19.07" y2="19.07"></line><line x1="2" y1="12" x2="6" y2="12"></line><line x1="18" y1="12" x2="22" y2="12"></line><line x1="4.93" y1="19.07" x2="7.76" y2="16.24"></line><line x1="16.24" y1="7.76" x2="19.07" y2="4.93"></line></svg> <span class="text-semibold display-block">Loading</span>')
    }, 0); 

    window.setTimeout(function () {
       message.html('<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-loader spin"><line x1="12" y1="2" x2="12" y2="6"></line><line x1="12" y1="18" x2="12" y2="22"></line><line x1="4.93" y1="4.93" x2="7.76" y2="7.76"></line><line x1="16.24" y1="16.24" x2="19.07" y2="19.07"></line><line x1="2" y1="12" x2="6" y2="12"></line><line x1="18" y1="12" x2="22" y2="12"></line><line x1="4.93" y1="19.07" x2="7.76" y2="16.24"></line><line x1="16.24" y1="7.76" x2="19.07" y2="4.93"></line></svg> <span class="text-semibold display-block">Please wait</span>')
    }, 2000); 

    window.setTimeout(function () {
       message.addClass('bg-danger').html('<i class="flaticon-danger-3"></i> <span class="text-semibold display-block">Load error</span>')
    }, 4000);

    window.setTimeout(function () {
       $(block).unblock({
        onUnblock: function(){
            message.removeClass('bg-danger');
        }
       });
    }, 6000);
});