<?php

include 'core/class/include.php';

// Redirige l'utilisateur si il n'est pas authentifier
if (!Account::isAuthentified())
{
    header('Location: ./login');
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no">
    <title>kPanel - Obfuscateurs</title>
    <link rel="icon" type="image/x-icon" href="/imgs/kpanel.png"/>
    <link href="assets/css/loader.css" rel="stylesheet" type="text/css" />
    <script src="assets/js/loader.js"></script>

    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <link href="https://fonts.googleapis.com/css?family=Quicksand:400,500,600,700&display=swap" rel="stylesheet">
    <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/css/plugins.css" rel="stylesheet" type="text/css" />
    <!-- END GLOBAL MANDATORY STYLES -->

    <!-- BEGIN PAGE LEVEL PLUGINS/CUSTOM STYLES -->
    <link href="plugins/apex/apexcharts.css" rel="stylesheet" type="text/css">
    <link href="assets/css/dashboard/dash_2.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" type="text/css" href="plugins/select2/select2.min.css">
        <style>
    .faq-question-q-box {
        height: 30px;
        width: 30px;
        color: #6658dd;
        text-align: center;
        border-radius: 50%;
        float: left;
        font-weight: 700;
        line-height: 30px;
        background-color: rgba(102,88,221,.15);
    }
    .faq-question {
        margin-top: 0;
        margin-left: 50px;
        font-weight: 400;
        font-size: 16px;
    }
    .faq-answer {
        margin-left: 50px;
        color: #98a6ad;
    }
    .offset-lg-1 {
        margin-left: 2.33333%;
    }
    .mb-3, .my-3 {
        margin-bottom: 0.5rem!important;
    }
    .pt-5, .py-5 {
        padding-top: 4.5rem!important;
    }
    </style>
    <!-- END PAGE LEVEL PLUGINS/CUSTOM STYLES -->

</head>
<body class="alt-menu sidebar-noneoverflow">
    <!-- BEGIN LOADER -->
    <div id="load_screen"> <div class="loader"> <div class="loader-content">
        <div class="spinner-grow align-self-center"></div>
    </div></div></div>
    <!--  END LOADER -->

    <!--  BEGIN NAVBAR  -->
    <div class="header-container">
        <header class="header navbar navbar-expand-sm">

            <a href="javascript:void(0);" class="sidebarCollapse" data-placement="bottom"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-menu"><line x1="3" y1="12" x2="21" y2="12"></line><line x1="3" y1="6" x2="21" y2="6"></line><line x1="3" y1="18" x2="21" y2="18"></line></svg></a>

            <div class="nav-logo align-self-center">
                <a class="navbar-brand" href="index.html"><img alt="logo" src="/imgs/kpanel.png"> <span class="navbar-brand-name">Panel</span></a>
            </div>

            <ul class="navbar-item flex-row mr-auto">
                <!-- Séparation du header -->
            </ul>

            <ul class="navbar-item flex-row nav-dropdowns">

                <li class="nav-item dropdown user-profile-dropdown order-lg-0 order-1">
                    <a href="javascript:void(0);" class="nav-link dropdown-toggle user" id="user-profile-dropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <div class="media">
                            <img src="<?php echo Account::GetPP(); ?>" class="img-fluid" alt="admin-profile">
                            <div class="media-body align-self-center">
                                <h6><span>Bonjour,</span>  <?php
                  $hisrole = Account::GetRole();
                  $rolecolor = Account::GetRoleColor();
                  $rolecolorlink = Account::GetRoleColorFire();
                  $name = Account::GetUsername();
                  if (Account::IsAdmin()) {
                    $named = "<span style='color: #000000; font-weight: bold; text-shadow: 0 0 5px ".$rolecolor.", 0 0 5px ".$rolecolor."; background: url(".$rolecolorlink.") repeat scroll 0% 0% transparent;}'>".$name."</span>";
                  }
                  else {
                    $named = "<span>".$name."</span>";
                  }

                  echo $named;
                  ?></h6>
                            </div>
                        </div>
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down"><polyline points="6 9 12 15 18 9"></polyline></svg>
                    </a>
                    <div class="dropdown-menu position-absolute animated fadeInUp" aria-labelledby="user-profile-dropdown">
                        <div class="">
                            <div class="dropdown-item">
                                <a class="" href="/profile"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-user"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg> Mon profile</a>
                            </div>
                            <div class="dropdown-item">
                                <a class="" href="/logout"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-log-out"><path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"></path><polyline points="16 17 21 12 16 7"></polyline><line x1="21" y1="12" x2="9" y2="12"></line></svg> Deconnexion</a>
                            </div>
                        </div>
                    </div>

                </li>
            </ul>
        </header>
    </div>
    <!--  END NAVBAR  -->

    <!--  BEGIN MAIN CONTAINER  -->
    <div class="main-container" id="container">

        <div class="overlay"></div>
        <div class="search-overlay"></div>

        <!--  BEGIN TOPBAR  -->
        <div class="topbar-nav header navbar" role="banner">
            <nav id="topbar">
                <ul class="navbar-nav theme-brand flex-row  text-center">
                    <li class="nav-item theme-logo">
                        <a href="index.html">
                            <img src="/imgs/kpanel.png" class="navbar-logo" alt="logo">
                        </a>
                    </li>
                    <li class="nav-item theme-text">
                        <a href="#" class="nav-link"> Panel </a>
                    </li>
                </ul>

                <ul class="list-unstyled menu-categories" id="topAccordion">

                    <li class="menu single-menu">
                        <a href="/dashboard">
                            <div class="">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-home"><path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path><polyline points="9 22 9 12 15 12 15 22"></polyline></svg>
                                <span>Dashboard</span>
                            </div>
                        </a>
                    </li>

                    <li class="menu single-menu">
                        <a href="/servers">
                            <div class="">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-server"><rect x="2" y="2" width="20" height="8" rx="2" ry="2"></rect><rect x="2" y="14" width="20" height="8" rx="2" ry="2"></rect><line x1="6" y1="6" x2="6.01" y2="6"></line><line x1="6" y1="18" x2="6.01" y2="18"></line></svg>
                                <span>Serveurs</span>
                            </div>
                        </a>
                        
                    </li>
                    
                    <li class="menu single-menu">
                        <a href="/history">
                            <div class="">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-clock"><circle cx="12" cy="12" r="10"></circle><polyline points="12 6 12 12 16 14"></polyline></svg>
                                <span>Historique</span>
                            </div>
                        </a>
                    </li>

                    <li class="menu single-menu active">
                        <a href="/obfuscator">
                            <div class="">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-settings"><circle cx="12" cy="12" r="3"></circle><path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"></path></svg>
                                <span>Obfuscateurs</span>
                            </div>
                        </a>
                    </li>

                    <li class="menu single-menu">
                        <a href="#lua" data-toggle="collapse" aria-expanded="false" class="dropdown-toggle">
                            <div class="">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-code"><polyline points="16 18 22 12 16 6"></polyline><polyline points="8 6 2 12 8 18"></polyline></svg>
                                <span>Outils Lua</span>
                            </div>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down"><polyline points="6 9 12 15 18 9"></polyline></svg>
                        </a>
                        <ul class="collapse submenu list-unstyled" id="lua"  data-parent="#topAccordion">
                            <li>
                                <a href="/bdfinder"> Backdoor Finder </a>
                            </li>
                            <li>
                                <a href="/smartlua"> Smart Lua </a>
                            </li>
                        </ul>
                    </li>

                    <li class="menu single-menu">
                        <a href="/payload">
                            <div class="">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-file"><path d="M13 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V9z"></path><polyline points="13 2 13 9 20 9"></polyline></svg>
                                <span>Payload</span>
                            </div>
                        </a>
                    </li>

                    <li class="menu single-menu">
                        <a href="#more" data-toggle="collapse" aria-expanded="false" class="dropdown-toggle">
                            <div class="">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="16"></line><line x1="8" y1="12" x2="16" y2="12"></line></svg>
                                <span>Plus</span>
                            </div>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down"><polyline points="6 9 12 15 18 9"></polyline></svg>
                        </a>
                        <ul class="collapse submenu list-unstyled" id="more" data-parent="#topAccordion">
                            <li>
                                <a href="/rules"> Règles</a>
                            </li>
                            <li>
                                <a href="/wos"> <span style="color: #000000; font-weight: bold; text-shadow: 0 0 5px #800080, 0 0 5px #800080; background: url(/imgs/fire_purple.gif) repeat scroll -5% 0% transparent;">Wall Of Shame</span> </a>
                            </li>
                        </ul>
                    </li>

                    <?php
                        if(Account::IsAdmin()) {?>
                    <li class="menu single-menu">
                        <a href="#admin" data-toggle="collapse" aria-expanded="false" class="dropdown-toggle">
                            <div class="">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="16"></line><line x1="8" y1="12" x2="16" y2="12"></line></svg>
                                <span>Administration</span>
                            </div>
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down"><polyline points="6 9 12 15 18 9"></polyline></svg>
                        </a>
                        <ul class="collapse submenu list-unstyled" id="admin" data-parent="#topAccordion">
                            <li>
                                <a href="/users"> Utilisateurs</a>
                            </li>
                            <li>
                                <a href="/allservers"> Tout les serveurs </a>
                            </li>
                            <li>
                                <a href="/logs"> Logs </a>
                            </li>
                        </ul>
                    </li>
                        <?php }
                    ?>
                </ul>
            </nav>
        </div>
        <!--  END TOPBAR  -->
        
        <!--  BEGIN CONTENT PART  -->
        <div id="content" class="main-content">
            <div class="layout-px-spacing">

                <div class="row layout-top-spacing">

                    <div id="basic" class="col-lg-12 layout-spacing">

                            <div class="statbox widget box box-shadow">

                                <div class="widget-header">

                                    <div class="row">

                                        <div class="col-xl-12 col-md-12 col-sm-12 col-12">

                                            <h4></h4>

                                        </div>                 

                                    </div>

                                </div>

                                <div class="widget-content widget-content-area">



                                    <div class="row">

                                        <div class="col-lg-9 mx-auto">

                                            <div class="form-group mb-4 text-center">
                                                
                                               <i class="mdi mdi-clipboard-text mdi-4x thisone" aria-hidden="true" style="font-size: 2rem;"></i>
                    <h3 class="mb-3">Règlement</h3>
                    <p class="text-muted">Tout non respect du règlement ce résulterat d'un bannisement permanent.</p>
                    </div>
                    <div class="row pt-5">
                    <div class="col-lg-6 offset-lg-1">
                    <div>
                    <div class="faq-question-q-box">Q.</div>
                    <h4 class="faq-question" data-wow-delay=".1s">Est-ce que je peux donner, vendre ou prêter mon compte kPanel ?</h4>
                    <p class="faq-answer mb-4">Non le partage, la vente ou le prêt de son compte kPanel est strictement interdit sauf sous autorisation.</p>
                    </div>
                    <div>
                    <div class="faq-question-q-box">Q.</div>
                    <h4 class="faq-question">Mauvaise utilisation de kPanel</h4>
                    <p class="faq-answer mb-4">Toute utilisation du panel ayant pour but d'affecter le site, les machines du panel, le panel, les admins du panel ou les clients du panel kPanel et/ou la Kalysia, les membres de la Kalysia ou les clients de leurs produits de façon négative est interdite et se résultera par un bannissement.</p>
                    </div>
                    <div>
                    <div class="faq-question-q-box">Q.</div>
                    <h4 class="faq-question">Est-ce que j'ai le droit de me servir de kPanel pour me faire de l'argent ?</h4>
                    <p class="faq-answer mb-4">La vente de service liée à kPanel est autorisée sous certaines conditions.</p>
                    </div>
                    <div>
                    <div class="faq-question-q-box">Q.</div>
                    <h4 class="faq-question" data-wow-delay=".1s">Est-ce que j'ai le droit de me servir de kPanel ou autre chose liée à kPanel pour me faire de l'argent ?</h4>
                    <p class="faq-answer mb-4">Oui, recevoir de l'argent grâce à kPanel ou vendre un service, objet, logiciel, contenu vidéo etc lié à kPanel et ses membres et/ou à Kalysia et ses membres est autorisé sous certaines conditions (exemple: Retirer une backdoor d'un serveur, vendre un dll, vendre des payload/visuels, vendre des menus, scam une personne, vendre des info sur un serveur etc)</p>
                    </div>
                    <div>
                    <div class="faq-question-q-box">Q.</div>
                    <h4 class="faq-question" data-wow-delay=".1s">L'utilisation de doubles comptes ?</h4>
                    <p class="faq-answer mb-4">Il est interdit d'utiliser des doubles comptes.</p>
                    </div>


                    </div>
                    <div class="col-lg-5 offset-lg-1">
                    <div>
                    <div class="faq-question-q-box">Q.</div>
                    <h4 class="faq-question">kPanel propose-t-il un programme de <a href="https://fr.wikipedia.org/wiki/Bug_bounty" target="_newblank">Bug bounty</a> ?</h4>
                    <p class="faq-answer mb-4">Toute personne rapportant des bugs/exploits sur kPanel sera récompensée en fonction de la gravité du bug/exploit s'il ne détruit pas kPanel avec. (Il est possible que le bug soit tout petit et qu'il n'y ait aucune récompense, car pas assez important).</p>
                    </div>
                    <div>
                    <div class="faq-question-q-box">Q.</div>
                    <h4 class="faq-question">Règlement Social</h4>
                    <p class="faq-answer mb-4">Toute alliance avec une équipe, une écurie, une armée, un arsenal, une bande, une brigade, un camp, un collectif, un escadron, une escouade, une formation, un laboratoire, un peloton, un régiment, une team, une troupe et/ou une union de personnes hostiles à kPanel et/ou le site, les machines du panel, le panel, les admins du panel ou les acheteurs du panel kPanel et/ou à Kalysia, les membres de la Kalysia ou les acheteurs de leurs produits se résultera par un bannissement.</p>
                    </div>

                    <div>
                    <div class="faq-question-q-box">Q.</div>
                    <h4 class="faq-question" data-wow-delay=".1s">Règlement du Workshop Steam</h4>
                    <p class="faq-answer mb-4">Il est interdit de poster des backdoors sur le workshop steam quel que soit l'addon ou les serveurs qui l'ont dans leurs collections.
                    </p>
                    </div>
                    <div>
                    <div class="faq-question-q-box">Q.</div>
                    <h4 class="faq-question" data-wow-delay=".1s">J'ai le droit de récupérer les html de kPanel ?</h4>
                    <p class="faq-answer mb-4">Non il vous est totalement interdit de récupérer les html du panel kPanel sauf sous certaines conditions.</p>
                    </div>
                    </div>
                    </div>

                                            </div>

                                        </div>                                        

                                    </div>



                                </div>

                            </div>

                        </div>

                </div>

                <div class="footer-wrapper">
                    <div class="footer-section f-section-1">
                        <p class="">Copyright © 2020 <a target="_blank" href="https://discord.gg/7EXMj4e">Eradium</a>, Tout droits resérvé.</p>
                    </div>
                    <div class="footer-section f-section-2">
                        <p class="">Codé par <a target="_blank" href="https://discord.gg/7EXMj4e">Eradium</a></p>
                    </div>
                </div>

            </div>
        </div>
        <!--  END CONTENT PART  -->

    </div>
    <!-- END MAIN CONTAINER -->

    <!-- BEGIN GLOBAL MANDATORY SCRIPTS -->
    <script src="assets/js/libs/jquery-3.1.1.min.js"></script>
    <script src="bootstrap/js/popper.min.js"></script>
    <script src="bootstrap/js/bootstrap.min.js"></script>
    <script src="plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
    <script src="assets/js/app.js"></script>
    <script>
        $(document).ready(function() {
            App.init();
        });
    </script>
    <script src="assets/js/custom.js"></script>
    <!-- END GLOBAL MANDATORY SCRIPTS -->

    <!-- BEGIN PAGE LEVEL PLUGINS/CUSTOM SCRIPTS -->
    <script src="plugins/apex/apexcharts.min.js"></script>
    <script src="assets/js/dashboard/dash_2.js"></script>
        <script src="plugins/select2/select2.min.js"></script>

    <script src="plugins/select2/custom-select2.js"></script>
    <script>

    </script>
    <!-- BEGIN PAGE LEVEL PLUGINS/CUSTOM SCRIPTS -->
</body>
</html>