/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.supdate.check.md5;

import com.google.gson.reflect.TypeToken;
import fr.theshark34.supdate.SUpdate;
import fr.theshark34.supdate.check.CheckMethod;
import fr.theshark34.supdate.check.FileInfos;
import fr.theshark34.supdate.check.md5.MD5FileInfos;
import fr.theshark34.supdate.exception.UnableToCheckException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

public class MD5CheckMethod
extends CheckMethod {
    @Override
    public String getName() {
        return "md5-check-method";
    }

    @Override
    public Type getListType() {
        return new TypeToken<List<MD5FileInfos>>(){}.getType();
    }

    @Override
    public boolean checkFile(SUpdate sUpdate, FileInfos infos) throws UnableToCheckException {
        MD5FileInfos md5FileInfo = (MD5FileInfos)infos;
        File localFile = new File(sUpdate.getOutputFolder(), infos.getFileRelativePath());
        if (!localFile.exists()) {
            return true;
        }
        try {
            int numRead;
            FileInputStream fis = new FileInputStream(localFile);
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance("MD5");
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            ((InputStream)fis).close();
            byte[] md5Bytes = complete.digest();
            String md5 = "";
            for (byte b : md5Bytes) {
                md5 = md5 + Integer.toString((b & 0xFF) + 256, 16).substring(1);
            }
            return !md5.equals(md5FileInfo.getMD5());
        }
        catch (IOException e) {
            throw new UnableToCheckException(localFile, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnableToCheckException(localFile, e);
        }
    }
}

