/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.swinger.animation;

import com.sun.awt.AWTUtilities;
import fr.theshark34.swinger.animation.QueryLoopAction;
import java.awt.Window;

public class Animator {
    public static final int SLOW = 20;
    public static final int NORMAL = 10;
    public static final int FAST = 5;

    public static void query(final long to, final QueryLoopAction loopAction) {
        Thread t = new Thread(){

            @Override
            public void run() {
                for (long query = 0L; query < to + 1L; ++query) {
                    loopAction.onLoop(query);
                }
            }
        };
        t.start();
    }

    public static void query(final long to, final long toWait, final QueryLoopAction loopAction) {
        Thread t = new Thread(){

            @Override
            public void run() {
                for (long query = 0L; query < to + 1L; ++query) {
                    loopAction.onLoop(query);
                    try {
                        2.sleep(toWait);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        };
        t.start();
    }

    public static void query(final long from, final long to, final long toWait, final QueryLoopAction loopAction) {
        Thread t = new Thread(){

            @Override
            public void run() {
                for (long query = from; query < to + 1L; ++query) {
                    loopAction.onLoop(query);
                    try {
                        3.sleep(toWait);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        };
        t.start();
    }

    public static void query(final long from, final long to, final long speed, final long toWait, final QueryLoopAction loopAction) {
        Thread t = new Thread(){

            @Override
            public void run() {
                for (long query = from; query < to + 1L; query += speed) {
                    loopAction.onLoop(query);
                    try {
                        4.sleep(toWait);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        };
        t.start();
    }

    public static void fadeInFrame(Window toFade) {
        Animator.fade(toFade, 10, false, null);
    }

    public static void fadeInFrame(Window toFade, Runnable callback) {
        Animator.fade(toFade, 10, false, callback);
    }

    public static void fadeInFrame(Window toFade, int speed) {
        Animator.fade(toFade, speed, false, null);
    }

    public static void fadeInFrame(Window toFade, int speed, Runnable callback) {
        Animator.fade(toFade, speed, false, callback);
    }

    public static void fadeOutFrame(Window toFade) {
        Animator.fade(toFade, 10, true, null);
    }

    public static void fadeOutFrame(Window toFade, Runnable callback) {
        Animator.fade(toFade, 10, true, callback);
    }

    public static void fadeOutFrame(Window toFade, int speed) {
        Animator.fade(toFade, speed, true, null);
    }

    public static void fadeOutFrame(Window toFade, int speed, Runnable callback) {
        Animator.fade(toFade, speed, true, callback);
    }

    private static void fade(final Window toFade, int speed, final boolean inverted, final Runnable callback) {
        Animator.query(100L, speed, new QueryLoopAction(){

            @Override
            public void onLoop(long query) {
                AWTUtilities.setWindowOpacity((Window)toFade, (float)(inverted ? (float)(100L - query) / 100.0f : (float)query / 100.0f));
                if (query == 100L && callback != null) {
                    callback.run();
                }
            }
        });
    }
}

