/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.supdate.application.integrated;

import com.google.gson.reflect.TypeToken;
import fr.theshark34.supdate.SUpdate;
import fr.theshark34.supdate.application.Application;
import fr.theshark34.supdate.application.event.ApplicationEvent;
import fr.theshark34.supdate.application.event.FileCheckingEvent;
import fr.theshark34.supdate.application.event.fileaction.FileActionEvent;
import fr.theshark34.supdate.exception.BadServerResponseException;
import fr.theshark34.supdate.exception.FileNoPermissionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FileDeleter
extends Application {
    private List<String> ignoreList = new ArrayList<String>();

    @Override
    public String getName() {
        return "FileDeleter";
    }

    @Override
    public boolean isServerRequired() {
        return true;
    }

    @Override
    public void onInit(ApplicationEvent event) {
    }

    @Override
    public void onStart(ApplicationEvent event) {
        SUpdate.logger.info("[FileDeleter] Getting the ignore list", new Object[0]);
        try {
            Object list = event.getSUpdate().getServerRequester().sendRequest("get-ignore-list", new TypeToken<List<String>>(){}.getType());
            if (list instanceof String) {
                throw new BadServerResponseException((String)list);
            }
            List fileList = (List)list;
            for (String file : fileList) {
                this.ignoreList.add(file);
            }
        }
        catch (IOException e) {
            SUpdate.logger.warning("[FileDeleter] Unable to get the ignore list, desactivating the FileDeleter. Error : ", e);
            this.ignoreList = null;
        }
        catch (BadServerResponseException e) {
            SUpdate.logger.warning("[FileDeleter] Unable to get the ignore list, desactivating the FileDeleter. Error : ", e);
            this.ignoreList = null;
        }
    }

    @Override
    public boolean onFileChecking(FileCheckingEvent event) {
        if (this.ignoreList == null) {
            return event.getCheckResult();
        }
        this.ignoreList.add(event.getCheckedFilePath());
        return event.getCheckResult();
    }

    @Override
    public void onFileAction(FileActionEvent event) {
    }

    @Override
    public void onUpdateEnd(ApplicationEvent event) {
        SUpdate.logger.info("[FileDeleter] Deleting the unknown files", new Object[0]);
        ArrayList<File> files = FileDeleter.listFiles(event.getSUpdate().getOutputFolder());
        for (File file : files) {
            if (this.isOnIgnoreList(event.getSUpdate(), file)) continue;
            try {
                SUpdate.logger.info("[FileDeleter] Deleting file '%s'.", file.getAbsolutePath());
                event.getSUpdate().getFileManager().delete(file);
            }
            catch (FileNoPermissionException e) {
                SUpdate.logger.warning("[FileDeleter] The file '" + file.getAbsolutePath() + "' wasn't deleted, error :", e);
            }
        }
    }

    public static ArrayList<File> listFiles(File folder) {
        File[] files = folder.listFiles();
        ArrayList<File> list = new ArrayList<File>();
        if (files == null) {
            return list;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                list.addAll(FileDeleter.listFiles(f));
                continue;
            }
            list.add(f);
        }
        return list;
    }

    public boolean isOnIgnoreList(SUpdate sUpdate, File file) {
        for (String ignoredFilePath : this.ignoreList) {
            File ignoredFile = new File(sUpdate.getOutputFolder(), ignoredFilePath);
            if (!ignoredFile.getAbsolutePath().equals(file.getAbsolutePath()) && !file.getAbsolutePath().contains(ignoredFile.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }
}

