/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.util;

import fr.theshark34.openlauncherlib.util.LogUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JOptionPane;

public class CrashReporter {
    private File dir;
    private String name;

    public CrashReporter(String name, File dir) {
        this.name = name;
        this.dir = dir;
    }

    public void catchError(Exception e, String message) {
        String msg;
        LogUtil.err("ex-caught");
        System.out.println(CrashReporter.makeCrashReport(this.name, e));
        try {
            File report = this.writeError(e);
            msg = "\nThe crash report is in : " + report.getAbsolutePath() + "";
        }
        catch (IOException e2) {
            LogUtil.err("report-error");
            e.printStackTrace();
            msg = "\nAnd unable to write the crash report :( : " + e2;
        }
        JOptionPane.showMessageDialog(null, message + "\n" + e + "\n" + msg, "Error", 0);
        System.exit(1);
    }

    public File writeError(Exception e) throws IOException {
        File file;
        int number = 0;
        while ((file = new File(this.dir, "crash-" + number + ".txt")).exists()) {
            ++number;
        }
        LogUtil.info("writing-crash", file.getAbsolutePath());
        file.getParentFile().mkdirs();
        FileWriter fw = new FileWriter(file);
        fw.write(CrashReporter.makeCrashReport(this.name, e));
        fw.close();
        return file;
    }

    public File getDir() {
        return this.dir;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String makeCrashReport(String projectName, Exception e) {
        StackTraceElement[] stackTrace;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        String report = "# " + projectName + " Crash Report\n\r#\n\r# At : " + dateFormat.format(date) + "\n\r#\n\r# Exception : " + e.getClass().getSimpleName() + "\n\r";
        report = report + "\n\r# " + e.toString();
        for (StackTraceElement element : stackTrace = e.getStackTrace()) {
            report = report + "\n\r#     " + element;
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            StackTraceElement[] causeStackTrace;
            report = report + "\n\r# Caused by: " + cause.toString();
            for (StackTraceElement element : causeStackTrace = cause.getStackTrace()) {
                report = report + "\n\r#     " + element;
            }
        }
        return report;
    }
}

