/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.swinger.colored;

import fr.theshark34.swinger.Swinger;
import fr.theshark34.swinger.abstractcomponents.AbstractButton;
import java.awt.Color;
import java.awt.Graphics;

public class SColoredButton
extends AbstractButton {
    private Color color;
    private Color colorHover;
    private Color colorDisabled;

    public SColoredButton(Color color) {
        this(color, null, null);
    }

    public SColoredButton(Color color, Color colorHover) {
        this(color, colorHover, null);
    }

    public SColoredButton(Color color, Color colorHover, Color colorDisabled) {
        if (color == null) {
            throw new IllegalArgumentException("Color == null");
        }
        this.color = color;
        this.colorHover = colorHover == null ? color.brighter() : colorHover;
        this.colorDisabled = colorDisabled == null ? color.darker() : colorDisabled;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color color = !this.isEnabled() ? this.colorDisabled : (super.isHover() ? this.colorHover : this.color);
        Swinger.fillFullsizedRect(g, this, color);
        if (this.getText() != null) {
            Swinger.activateAntialias(g);
            if (this.getTextColor() != null) {
                g.setColor(this.getTextColor());
            }
            Swinger.drawCenteredString(g, this.getText(), this.getBounds());
        }
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Color == null");
        }
        this.color = color;
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColorHover(Color colorHover) {
        if (colorHover == null) {
            throw new IllegalArgumentException("colorHover == null");
        }
        this.colorHover = colorHover;
        this.repaint();
    }

    public Color getColorHover() {
        return this.colorHover;
    }

    public void setColorDisabled(Color colorDisabled) {
        if (colorDisabled == null) {
            throw new IllegalArgumentException("colorDisabled == null");
        }
        this.colorDisabled = colorDisabled;
        this.repaint();
    }

    public Color getColorDisabled() {
        return this.colorDisabled;
    }
}

