/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.swinger.textured;

import fr.theshark34.swinger.Swinger;
import fr.theshark34.swinger.abstractcomponents.AbstractProgressBar;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class STexturedProgressBar
extends AbstractProgressBar {
    private BufferedImage backgroundTexture;
    private BufferedImage foregroundTexture;

    public STexturedProgressBar(BufferedImage backgroundTexture, BufferedImage foregroundTexture) {
        if (backgroundTexture == null) {
            throw new IllegalArgumentException("Background Texture == null");
        }
        this.backgroundTexture = backgroundTexture;
        if (foregroundTexture == null) {
            throw new IllegalArgumentException("Foreground Texture == null");
        }
        this.foregroundTexture = foregroundTexture;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Swinger.drawFullsizedImage(g, this, this.backgroundTexture);
        int fgSize = Swinger.crossMult(this.getValue(), this.getMaximum(), this.isVertical() ? this.getHeight() : this.getWidth());
        if (fgSize > 0) {
            BufferedImage subForeground = this.foregroundTexture.getSubimage(0, 0, this.isVertical() ? this.getWidth() : fgSize, this.isVertical() ? fgSize : this.getHeight());
            g.drawImage(subForeground, 0, 0, subForeground.getWidth(), subForeground.getHeight(), this);
        }
        if (this.isStringPainted() && this.getString() != null) {
            Swinger.activateAntialias(g);
            if (this.getStringColor() != null) {
                g.setColor(this.getStringColor());
            }
            Swinger.drawCenteredString(g, this.getString(), this.getBounds());
        }
    }

    public void setBackgroundTexture(BufferedImage backgroundTexture) {
        if (backgroundTexture == null) {
            throw new IllegalArgumentException("backgroundTexture == null");
        }
        this.backgroundTexture = backgroundTexture;
        this.repaint();
    }

    public BufferedImage getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public void setForegroundTexture(BufferedImage foregroundTexture) {
        if (foregroundTexture == null) {
            throw new IllegalArgumentException("foregroundTexture == null");
        }
        this.foregroundTexture = foregroundTexture;
        this.repaint();
    }

    public BufferedImage getForegroundTexture() {
        return this.foregroundTexture;
    }
}

