/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.minecraft;

import fr.theshark34.openlauncherlib.minecraft.AuthInfos;
import fr.theshark34.openlauncherlib.minecraft.GameFolder;
import fr.theshark34.openlauncherlib.minecraft.GameInfos;
import java.io.File;
import java.util.ArrayList;

public abstract class GameType {
    public static final GameType V1_5_2_LOWER = new GameType(){

        @Override
        public String getName() {
            return "1.5.2 or lower";
        }

        @Override
        public String getMainClass(GameInfos infos) {
            return "net.minecraft.launchwrapper.Launch";
        }

        @Override
        public ArrayList<String> getLaunchArgs(GameInfos infos, GameFolder folder, AuthInfos authInfos) {
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add(authInfos.getUsername());
            arguments.add("token:" + authInfos.getAccessToken() + ":" + authInfos.getUuid());
            arguments.add("--gameDir");
            arguments.add(infos.getGameDir().getAbsolutePath());
            arguments.add("--assetsDir");
            File assetsDir = new File(infos.getGameDir(), folder.getAssetsFolder());
            arguments.add(assetsDir.getAbsolutePath() + "/virtual/legacy/");
            return arguments;
        }
    };
    public static final GameType V1_7_2_LOWER = new GameType(){

        @Override
        public String getName() {
            return "1.7.2 or lower";
        }

        @Override
        public String getMainClass(GameInfos infos) {
            return "net.minecraft.client.main.Main";
        }

        @Override
        public ArrayList<String> getLaunchArgs(GameInfos infos, GameFolder folder, AuthInfos authInfos) {
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add("--username=" + authInfos.getUsername());
            arguments.add("--accessToken");
            arguments.add(authInfos.getAccessToken());
            arguments.add("--version");
            arguments.add(infos.getGameVersion().getName());
            arguments.add("--gameDir");
            arguments.add(infos.getGameDir().getAbsolutePath());
            arguments.add("--assetsDir");
            File assetsDir = new File(infos.getGameDir(), folder.getAssetsFolder());
            arguments.add(assetsDir.getAbsolutePath() + "/virtual/legacy/");
            arguments.add("--userProperties");
            arguments.add("{}");
            arguments.add("--uuid");
            arguments.add(authInfos.getUuid());
            arguments.add("--userType");
            arguments.add("legacy");
            return arguments;
        }
    };
    public static final GameType V1_7_10 = new GameType(){

        @Override
        public String getName() {
            return "1.7.10";
        }

        @Override
        public String getMainClass(GameInfos infos) {
            return "net.minecraft.client.main.Main";
        }

        @Override
        public ArrayList<String> getLaunchArgs(GameInfos infos, GameFolder folder, AuthInfos authInfos) {
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add("--username=" + authInfos.getUsername());
            arguments.add("--accessToken");
            arguments.add(authInfos.getAccessToken());
            if (authInfos.getClientToken() != null) {
                arguments.add("--clientToken");
                arguments.add(authInfos.getClientToken());
            }
            arguments.add("--version");
            arguments.add(infos.getGameVersion().getName());
            arguments.add("--gameDir");
            arguments.add(infos.getGameDir().getAbsolutePath());
            arguments.add("--assetsDir");
            File assetsDir = new File(infos.getGameDir(), folder.getAssetsFolder());
            arguments.add(assetsDir.getAbsolutePath());
            arguments.add("--assetIndex");
            arguments.add(infos.getGameVersion().getName());
            arguments.add("--userProperties");
            arguments.add("{}");
            arguments.add("--uuid");
            arguments.add(authInfos.getUuid());
            arguments.add("--userType");
            arguments.add("legacy");
            return arguments;
        }
    };
    public static final GameType V1_8_HIGHER = new GameType(){

        @Override
        public String getName() {
            return "1.8 or higher";
        }

        @Override
        public String getMainClass(GameInfos infos) {
            return "net.minecraft.client.main.Main";
        }

        @Override
        public ArrayList<String> getLaunchArgs(GameInfos infos, GameFolder folder, AuthInfos authInfos) {
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add("--username=" + authInfos.getUsername());
            arguments.add("--accessToken");
            arguments.add(authInfos.getAccessToken());
            if (authInfos.getClientToken() != null) {
                arguments.add("--clientToken");
                arguments.add(authInfos.getClientToken());
            }
            arguments.add("--version");
            arguments.add(infos.getGameVersion().getName());
            arguments.add("--gameDir");
            arguments.add(infos.getGameDir().getAbsolutePath());
            arguments.add("--assetsDir");
            File assetsDir = new File(infos.getGameDir(), folder.getAssetsFolder());
            arguments.add(assetsDir.getAbsolutePath());
            arguments.add("--assetIndex");
            String version = infos.getGameVersion().getName();
            int first = version.indexOf(46);
            int second = version.lastIndexOf(46);
            if (first != second) {
                version = version.substring(0, version.lastIndexOf(46));
            }
            if (infos.getGameVersion().getName().equals("1.13.1") || infos.getGameVersion().getName().equals("1.13.2")) {
                version = "1.13.1";
            }
            arguments.add(version);
            arguments.add("--userProperties");
            arguments.add("{}");
            arguments.add("--uuid");
            arguments.add(authInfos.getUuid());
            arguments.add("--userType");
            arguments.add("legacy");
            return arguments;
        }
    };
    public static final GameType V1_13_HIGHER_FORGE = new GameType(){

        @Override
        public String getName() {
            return "1.13 or higher with Forge";
        }

        @Override
        public String getMainClass(GameInfos infos) {
            return "cpw.mods.modlauncher.Launcher";
        }

        @Override
        public ArrayList<String> getLaunchArgs(GameInfos infos, GameFolder folder, AuthInfos authInfos) {
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add("--username=" + authInfos.getUsername());
            arguments.add("--accessToken");
            arguments.add(authInfos.getAccessToken());
            if (authInfos.getClientToken() != null) {
                arguments.add("--clientToken");
                arguments.add(authInfos.getClientToken());
            }
            arguments.add("--version");
            arguments.add(infos.getGameVersion().getName());
            arguments.add("--gameDir");
            arguments.add(infos.getGameDir().getAbsolutePath());
            arguments.add("--assetsDir");
            File assetsDir = new File(infos.getGameDir(), folder.getAssetsFolder());
            arguments.add(assetsDir.getAbsolutePath());
            arguments.add("--assetIndex");
            arguments.add("1.13.1");
            arguments.add("--userProperties");
            arguments.add("{}");
            arguments.add("--uuid");
            arguments.add(authInfos.getUuid());
            arguments.add("--userType");
            arguments.add("legacy");
            arguments.add("--launchTarget");
            arguments.add("fmlclient");
            arguments.add("--fml.forgeVersion");
            arguments.add("25.0.219");
            arguments.add("--fml.mcVersion");
            arguments.add("1.13.2");
            arguments.add("--fml.forgeGroup");
            arguments.add("net.minecraftforge");
            arguments.add("--fml.mcpVersion");
            arguments.add("20190213.203750");
            return arguments;
        }
    };

    public abstract String getName();

    public abstract String getMainClass(GameInfos var1);

    public abstract ArrayList<String> getLaunchArgs(GameInfos var1, GameFolder var2, AuthInfos var3);
}

