/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.supdate;

import com.google.gson.Gson;
import fr.theshark34.supdate.BarAPI;
import fr.theshark34.supdate.SUpdate;
import fr.theshark34.supdate.application.Application;
import fr.theshark34.supdate.application.event.ApplicationEvent;
import fr.theshark34.supdate.application.event.FileCheckingEvent;
import fr.theshark34.supdate.check.CheckMethod;
import fr.theshark34.supdate.check.FileInfos;
import fr.theshark34.supdate.check.md5.MD5CheckMethod;
import fr.theshark34.supdate.exception.BadServerResponseException;
import fr.theshark34.supdate.exception.BadServerVersionException;
import fr.theshark34.supdate.exception.ServerDisabledException;
import fr.theshark34.supdate.exception.ServerMissingSomethingException;
import fr.theshark34.supdate.exception.UnableToCheckException;
import fr.theshark34.supdate.models.CheckResponse;
import fr.theshark34.supdate.models.SizeResponse;
import fr.theshark34.supdate.models.StateResponse;
import fr.theshark34.supdate.models.VersionResponse;
import java.io.File;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Updater {
    public static final String FILES_FOLDER = "files";
    public static final CheckMethod DEFAULT_CHECK_METHOD = new MD5CheckMethod();
    private SUpdate sUpdate;

    public Updater(SUpdate sUpdate) {
        this.sUpdate = sUpdate;
    }

    public void start() throws BadServerResponseException, ServerDisabledException, BadServerVersionException, ServerMissingSomethingException, IOException {
        this.printInfos();
        long startTime = System.currentTimeMillis();
        this.checkState();
        this.checkVersion();
        this.checkCheckMethodAndApplications();
        this.sUpdate.getServerRequester().sendPostRequest("stats/update");
        for (Application app : this.sUpdate.getApplicationManager().getApplications()) {
            app.onStart(new ApplicationEvent(this.sUpdate));
        }
        SUpdate.logger.info("Listing the files", new Object[0]);
        List<FileInfos> fileList = this.createFileList();
        HashMap<URL, File> filesToDownload = new HashMap<URL, File>();
        ArrayList<String> filesPaths = new ArrayList<String>();
        SUpdate.logger.info("Checking them", new Object[0]);
        for (FileInfos fileInfos : fileList) {
            boolean checkResult;
            try {
                checkResult = this.sUpdate.getCheckMethod().checkFile(this.sUpdate, fileInfos);
            }
            catch (UnableToCheckException e) {
                e.printStackTrace();
                return;
            }
            for (Application app : this.sUpdate.getApplicationManager().getApplications()) {
                checkResult = app.onFileChecking(new FileCheckingEvent(this.sUpdate, fileInfos.getFileRelativePath(), checkResult));
            }
            if (!checkResult) continue;
            URL fileURL = new URL((this.sUpdate.getServerUrl() + (this.sUpdate.getServerUrl().endsWith("/") ? "" : "/") + FILES_FOLDER + "/" + fileInfos.getFileRelativePath()).replaceAll(" ", "%20"));
            File localFile = new File(this.sUpdate.getOutputFolder(), fileInfos.getFileRelativePath());
            filesToDownload.put(fileURL, localFile);
            filesPaths.add(fileInfos.getFileRelativePath());
        }
        BarAPI.setNumberOfFileToDownload(filesToDownload.size());
        SUpdate.logger.info("%d files were checked, %s", fileList.size(), filesToDownload.size() == 0 ? "nothing to download" : "need to download " + filesToDownload.size() + " of them.");
        CookieManager cookieManager = new CookieManager(null, CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(cookieManager);
        if (filesPaths.size() > 0) {
            SUpdate.logger.info("Requesting bytes to download... ", new Object[0]);
            this.getBytesToDownload(filesPaths);
            SUpdate.logger.info("Done: %d", BarAPI.getNumberOfTotalBytesToDownload());
            SUpdate.logger.info("Starting download the files", new Object[0]);
        }
        for (Map.Entry entry : filesToDownload.entrySet()) {
            this.sUpdate.getFileManager().download((URL)entry.getKey(), (File)entry.getValue());
        }
        this.sUpdate.getFileManager().stop();
        for (Application app : this.sUpdate.getApplicationManager().getApplications()) {
            app.onUpdateEnd(new ApplicationEvent(this.sUpdate));
        }
        this.printTotalTime(startTime);
    }

    private void printInfos() {
        SUpdate.logger.info("S-Update Client version 3.1.0-BETA by TheShark34", new Object[0]);
        SUpdate.logger.info("Current time is %s", new Date(System.currentTimeMillis()).toString());
        SUpdate.logger.info("Starting updating...", new Object[0]);
        SUpdate.logger.info("    Server URL: %s", this.sUpdate.getServerUrl());
        SUpdate.logger.info("    Output Dir: %s", this.sUpdate.getOutputFolder().getAbsolutePath());
    }

    private void checkState() throws BadServerResponseException, IOException, ServerDisabledException {
        SUpdate.logger.info("Connecting to the server... ", new Object[0]);
        Object stateResponse = this.sUpdate.getServerRequester().sendPostRequest("server/is-enabled", StateResponse.class);
        if (stateResponse instanceof String) {
            throw new BadServerResponseException((String)stateResponse);
        }
        boolean enabled = ((StateResponse)stateResponse).isEnabled();
        SUpdate.logger.info("Server " + (enabled ? "enabled" : "disabled !"), new Object[0]);
        if (!enabled) {
            throw new ServerDisabledException();
        }
    }

    private void checkVersion() throws BadServerResponseException, BadServerVersionException, IOException {
        Object versionResponse = this.sUpdate.getServerRequester().sendPostRequest("server/version", VersionResponse.class);
        if (versionResponse instanceof String) {
            throw new BadServerResponseException((String)versionResponse);
        }
        String[] splittedVersion = ((VersionResponse)versionResponse).getVersion().split("-");
        int version = Integer.parseInt(splittedVersion[0].replaceAll("\\.", ""));
        String revision = splittedVersion[1];
        String[] splittedMinVersion = "3.1.0-BETA".split("-");
        int minVersion = Integer.parseInt(splittedMinVersion[0].replaceAll("\\.", ""));
        String minRevision = splittedMinVersion[1];
        if (!revision.equals(minRevision)) {
            throw new BadServerVersionException(minRevision, revision, true);
        }
        if (version < minVersion) {
            throw new BadServerVersionException(splittedMinVersion[0], splittedVersion[0], false);
        }
        SUpdate.logger.info("Version : " + ((VersionResponse)versionResponse).getVersion(), new Object[0]);
    }

    private void checkCheckMethodAndApplications() throws BadServerResponseException, ServerMissingSomethingException, IOException {
        String checkMethodName = this.sUpdate.getCheckMethod().getName();
        Object response = this.sUpdate.getServerRequester().sendPostRequest("server/check/checkmethod/" + checkMethodName.replaceAll(" ", "%20"), CheckResponse.class);
        if (response instanceof String) {
            throw new BadServerResponseException((String)response);
        }
        if (!((CheckResponse)response).isPresent()) {
            throw new ServerMissingSomethingException("the Check Method " + checkMethodName);
        }
        SUpdate.logger.info("CheckMethod : " + checkMethodName, new Object[0]);
        String appsList = "";
        for (int i = 0; i < this.sUpdate.getApplicationManager().getApplications().size(); ++i) {
            String applicationName = this.sUpdate.getApplicationManager().getApplications().get(i).getName();
            if (this.sUpdate.getApplicationManager().getApplications().get(i).isServerRequired()) {
                response = this.sUpdate.getServerRequester().sendPostRequest("server/check/application/" + applicationName.replaceAll(" ", "%20"), CheckResponse.class);
                if (response instanceof String) {
                    throw new BadServerResponseException((String)response);
                }
                if (!((CheckResponse)response).isPresent()) {
                    throw new ServerMissingSomethingException("the application " + applicationName);
                }
            }
            appsList = i + 1 < this.sUpdate.getApplicationManager().getApplications().size() ? appsList + applicationName + ", " : appsList + applicationName + ".";
        }
        SUpdate.logger.info("Applications : %s", appsList);
        if (this.sUpdate.getApplicationManager().getApplications().size() == 0) {
            SUpdate.logger.info("No application", new Object[0]);
        }
    }

    private List<FileInfos> createFileList() throws IOException, BadServerResponseException {
        Object response = this.sUpdate.getServerRequester().sendPostRequest("server/list/" + this.sUpdate.getCheckMethod().getName().replaceAll(" ", "%20"), this.sUpdate.getCheckMethod().getListType());
        if (response instanceof String) {
            throw new BadServerResponseException((String)response);
        }
        return (List)response;
    }

    private void getBytesToDownload(List<String> filesToDownload) throws IOException, BadServerResponseException {
        Gson gson = new Gson();
        Object response = this.sUpdate.getServerRequester().sendPostRequest("server/size", SizeResponse.class, gson.toJson(filesToDownload).replaceAll(" ", "%20").getBytes());
        if (response instanceof String) {
            throw new BadServerResponseException((String)response);
        }
        BarAPI.setNumberOfTotalBytesToDownload(((SizeResponse)response).getSize());
    }

    private void printTotalTime(long startTime) {
        long totalTime = System.currentTimeMillis() - startTime;
        int seconds = (int)(totalTime / 1000L) % 60;
        int minutes = (int)(totalTime / 60000L % 60L);
        int hours = (int)(totalTime / 3600000L % 24L);
        String strTime = hours + " hours " + minutes + " minutes " + seconds + " seconds and " + totalTime % 1000L + " milliseconds.";
        SUpdate.logger.info("Update finished, total time : " + strTime, new Object[0]);
    }
}

