/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.util;

import fr.theshark34.openlauncherlib.FailException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.Properties;

public class Saver {
    private File file;
    private Properties properties;

    public Saver(File file) {
        this.file = file;
        this.properties = new Properties();
        if (file.exists()) {
            this.load();
        }
    }

    public void set(String key, String value) {
        this.properties.setProperty(key, value);
        this.save();
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public String get(String key, String def) {
        String value = this.properties.getProperty(key);
        return value == null ? def : value;
    }

    public void save() {
        try {
            this.properties.store(new BufferedWriter(new FileWriter(this.file)), "Generated by the OpenLauncherLib Saver");
        }
        catch (Throwable t) {
            throw new FailException("Can't save the properties", t);
        }
    }

    public void load() {
        try {
            this.properties.load(new FileInputStream(this.file));
        }
        catch (Throwable t) {
            throw new FailException("Can't load the properties", t);
        }
    }
}

