/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib;

import java.util.HashMap;
import java.util.Locale;

public class LanguageManager {
    public static final HashMap<String, String> ENGLISH = new HashMap();
    public static final HashMap<String, String> FRENCH = new HashMap();
    private static HashMap<String, String> currentLangSet = ENGLISH;

    public static String lang(String ... keys) {
        String total = "";
        for (String key : keys) {
            String text = currentLangSet.get(key);
            if (text == null) {
                text = ENGLISH.get(key);
            }
            total = total + (text == null ? key : text) + " ";
        }
        return total;
    }

    public static void setLang(HashMap<String, String> langSet) {
        currentLangSet = langSet;
    }

    public static HashMap<String, String> getCurrentLangSet() {
        return currentLangSet;
    }

    static {
        ENGLISH.put("hi-int", "OpenLauncherLib 3.0.5 by Adrien 'Litarvan' Navratil - Internal Launching System");
        ENGLISH.put("hi-ext", "OpenLauncherLib 3.0.5 by Adrien 'Litarvan' Navratil - External Launching System");
        ENGLISH.put("options", "Options");
        ENGLISH.put("ram", "RAM");
        ENGLISH.put("warn", "Warning");
        ENGLISH.put("splash-interrupted", "Splash wait time was interrupted !");
        ENGLISH.put("ex-caught", "Exception caught !");
        ENGLISH.put("report-error", "Unable to write the crash report !");
        ENGLISH.put("ram-empty", "Can't read ram : File is empty");
        ENGLISH.put("writing-crash", "Writing crash report to");
        ENGLISH.put("load-fail", "Can't load the given jar");
        ENGLISH.put("jar-notfound", "Can't find the given jar");
        ENGLISH.put("loading", "Loading file");
        ENGLISH.put("mc-check", "Checking Minecraft directory");
        ENGLISH.put("mc-int", "Creating internal launching profile for Minecraft");
        ENGLISH.put("mc-ext", "Creating external launching profile for Minecraft");
        ENGLISH.put("mc-cp", "Generating classpath");
        ENGLISH.put("log-err", "Error while writing the logs !");
        ENGLISH.put("log-end", "Error, logging ended suddenly");
        ENGLISH.put("launching", "Launching program. It is now");
        ENGLISH.put("init", "Initializing main class");
        ENGLISH.put("start", "Starting");
        ENGLISH.put("total", "Total time");
        ENGLISH.put("security", "Detected certificate information error, please delete META-INF in your JAR");
        ENGLISH.put("nat", "Loading the natives");
        ENGLISH.put("done", "Done");
        ENGLISH.put("ent", "Entire command");
        ENGLISH.put("support-forge", "Forge is a free open source library, consider supporting them at http://patreon.com/lexmanos");
        ENGLISH.put("old-tweak", "WARNING: You selected tweaking with a version under or equals as 1.5.2, this isn't fully supported, and could cause bugs.");
        ENGLISH.put("forge-optifine", "WARNING: You selected Forge tweak with Optifine/Shader, they are ONLY FOR VANILLA, the game wil probably not start, so for security, Optifine/Shader was/were disabled");
        ENGLISH.put("tweak-deprec", "WARNING: You selected GameTweaks other than forge with Minecraft 1.13 or greater, the tweaking system has been deleted since, game will probably not start");
        ENGLISH.put("forge-old", "WARNING: You selected Forge tweaking with a version under or equals as 1.5.2, forge is supposed to be installed in the jar (not with a tweaker), the game MAY NOT START !");
        FRENCH.put("hi-int", "OpenLauncherLib 3.0.4 par Adrien 'Litarvan' Navratil - Systeme de lancement interne");
        FRENCH.put("hi-ext", "OpenLauncherLib 3.0.4 par Adrien 'Litarvan' Navratil - Systeme de lancement externe");
        FRENCH.put("options", "Options");
        FRENCH.put("ram", "RAM");
        FRENCH.put("warn", "Attention");
        FRENCH.put("splash-interrupted", "Le temps d'attente du splash a ete interrompu !");
        FRENCH.put("ex-caught", "Exception attrapee !");
        FRENCH.put("report-error", "Impossible d'ecrire le crash report !");
        FRENCH.put("ram-empty", "Impossible de lire la RAM : Le fichier est vide");
        FRENCH.put("writing-crash", "Ecriture du crash report dans");
        FRENCH.put("load-fail", "Impossible de charger le jar");
        FRENCH.put("jar-notfound", "Impossible de trouver le jar");
        FRENCH.put("loading", "Chargement du fichier");
        FRENCH.put("mc-check", "Verification du dossier de Minecraft");
        FRENCH.put("mc-int", "Creation d'un profil de lancement interne pour Minecraft");
        FRENCH.put("mc-ext", "Creation d'un profil de lancement externe pour Minecraft");
        FRENCH.put("mc-cp", "Generation du classpath");
        FRENCH.put("log-err", "Erreur en ecrivant les logs !");
        FRENCH.put("log-end", "Erreur, le systeme de logs s'est brusquement arrete");
        FRENCH.put("launching", "Lancement du programme. Il est actuellement");
        FRENCH.put("init", "Initialization de la classe principale");
        FRENCH.put("start", "Lancement de");
        FRENCH.put("total", "Temps total");
        FRENCH.put("security", "Une erreur de certification a ete detectee, merci de supprimer le dossier META-INF de votre .jar");
        FRENCH.put("nat", "Chargement des natives");
        FRENCH.put("done", "Termine");
        FRENCH.put("ent", "Commande entiere");
        FRENCH.put("support-forge", "Forge est une librairie open source, supportez son developpement sur https://patreon.com/lexmanos");
        FRENCH.put("old-tweak", "ATTENTION: Vous avez choisi d'utiliser le tweaking avec une version inferieure ou egale a la 1.5.2, ce n'est pas vraiment supporte, des bugs peuvent survenir");
        FRENCH.put("forge-optifine", "ATTENTION: Vous avez selectionne les tweaks Forge avec Optifine/Shader, ces derniers sont SEULEMENT POUR LE VANILLA, le jeu ne demarrera s\u00c3\u00bbrement pas, donc Optifine/Shader ont ete desactives");
        FRENCH.put("tweak-deprec", "ATTENTION: Vous avez selectione des GameTweaks autre que Forge avec Minecraft 1.13 ou superieur, le systeme de tweaking a ete supprime depuis, le jeu ne demarrera probablement pas");
        FRENCH.put("forge-old", "ATTENTION: Vous avez selectionne le tweak Forge avec une version inferieure ou egale a la 1.5.2, forge est sense \u00c3\u00aatre installe a l'interieur du jar (et non pas via tweaking), le jeu POURAIT NE PAS DEMARRER !");
        if (Locale.getDefault().getLanguage().toLowerCase().startsWith("fr")) {
            LanguageManager.setLang(FRENCH);
        }
    }
}

