/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.util;

import fr.theshark34.openlauncherlib.util.LogUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ProcessLogManager
extends Thread {
    private boolean print = true;
    private BufferedReader reader;
    private File toWrite;
    private BufferedWriter writer;

    public ProcessLogManager(InputStream input) {
        this(input, null);
    }

    public ProcessLogManager(InputStream input, File toWrite) {
        this.reader = new BufferedReader(new InputStreamReader(input));
        this.toWrite = toWrite;
        if (toWrite != null) {
            try {
                this.writer = new BufferedWriter(new FileWriter(toWrite));
            }
            catch (IOException e) {
                LogUtil.err("log-err", e.toString());
            }
        }
    }

    @Override
    public void run() {
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                if (this.print) {
                    System.out.println(line);
                }
                if (this.writer == null) continue;
                try {
                    this.writer.write(line + "\n");
                }
                catch (IOException e) {
                    LogUtil.err("log-err", e.toString());
                }
            }
        }
        catch (IOException e) {
            LogUtil.err("log-end", e.toString());
            this.interrupt();
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isPrint() {
        return this.print;
    }

    public void setPrint(boolean print) {
        this.print = print;
    }

    public File getToWrite() {
        return this.toWrite;
    }

    public void setToWrite(File toWrite) {
        this.toWrite = toWrite;
    }
}

