/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.util.explorer;

import fr.theshark34.openlauncherlib.FailException;
import java.io.File;
import java.util.ArrayList;

public class FilesUtil {
    public static ArrayList<File> listRecursive(File directory) {
        ArrayList<File> files = new ArrayList<File>();
        File[] fs = directory.listFiles();
        if (fs == null) {
            return files;
        }
        for (File f : fs) {
            if (f.isDirectory()) {
                files.addAll(FilesUtil.listRecursive(f));
            }
            files.add(f);
        }
        return files;
    }

    public static File get(File root, String file) {
        File f = new File(root, file);
        if (!f.exists()) {
            throw new FailException("Given file/directory doesn't exist !");
        }
        return f;
    }

    public static File dir(File d) {
        if (!d.isDirectory()) {
            throw new FailException("Given directory is not one !");
        }
        return d;
    }

    public static File dir(File root, String dir) {
        return FilesUtil.dir(FilesUtil.get(root, dir));
    }

    public static File[] list(File dir) {
        File[] files = FilesUtil.dir(dir).listFiles();
        return files == null ? new File[]{} : files;
    }
}

