/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.swinger.textured;

import fr.theshark34.swinger.Swinger;
import fr.theshark34.swinger.abstractcomponents.AbstractButton;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class STexturedButton
extends AbstractButton {
    private Image texture;
    private Image textureHover;
    private Image textureDisabled;

    public STexturedButton(BufferedImage texture) {
        this(texture, null, null);
    }

    public STexturedButton(BufferedImage texture, BufferedImage textureHover) {
        this(texture, textureHover, null);
    }

    public STexturedButton(BufferedImage texture, BufferedImage textureHover, BufferedImage textureDisabled) {
        if (texture == null) {
            throw new IllegalArgumentException("texture == null");
        }
        this.texture = texture;
        this.textureHover = textureHover == null ? Swinger.fillImage(Swinger.copyImage(texture), Swinger.HOVER_COLOR, this.getParent()) : textureHover;
        this.textureDisabled = textureDisabled == null ? Swinger.fillImage(Swinger.copyImage(texture), Swinger.DISABLED_COLOR, this.getParent()) : textureDisabled;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Image texture = !this.isEnabled() ? this.textureDisabled : (super.isHover() ? this.textureHover : this.texture);
        Swinger.drawFullsizedImage(g, this, texture);
        if (this.getText() != null) {
            Swinger.activateAntialias(g);
            if (this.getTextColor() != null) {
                g.setColor(this.getTextColor());
            }
            Swinger.drawCenteredString(g, this.getText(), this.getBounds());
        }
    }

    public void setTexture(Image texture) {
        if (texture == null) {
            throw new IllegalArgumentException("texture == null");
        }
        this.texture = texture;
        this.repaint();
    }

    public void setTextureHover(Image textureHover) {
        if (textureHover == null) {
            throw new IllegalArgumentException("textureHover == null");
        }
        this.textureHover = textureHover;
        this.repaint();
    }

    public void setTextureDisabled(Image textureDisabled) {
        if (textureDisabled == null) {
            throw new IllegalArgumentException("textureDisabled == null");
        }
        this.textureDisabled = textureDisabled;
        this.repaint();
    }

    public Image getTexture() {
        return this.texture;
    }

    public Image getTextureHover() {
        return this.textureHover;
    }

    public Image getTextureDisabled() {
        return this.textureDisabled;
    }

    public void setBounds(int x, int y) {
        this.setBounds(x, y, this.texture.getWidth(this.getParent()), this.texture.getHeight(this.getParent()));
    }
}

