/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.swinger.abstractcomponents;

import fr.theshark34.swinger.event.SwingerEvent;
import fr.theshark34.swinger.event.SwingerEventListener;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JComponent;

public abstract class AbstractButton
extends JComponent
implements MouseListener {
    private String text;
    private Color textColor;
    private ArrayList<SwingerEventListener> eventListeners = new ArrayList();
    private boolean hover = false;

    public AbstractButton() {
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isEnabled()) {
            for (SwingerEventListener eventListener : this.eventListeners) {
                eventListener.onEvent(new SwingerEvent(this, 0));
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.hover = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.hover = false;
        this.repaint();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.repaint();
    }

    public void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text == null");
        }
        this.text = text;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void setTextColor(Color textColor) {
        if (textColor == null) {
            throw new IllegalArgumentException("textColor == null");
        }
        this.textColor = textColor;
        this.repaint();
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void addEventListener(SwingerEventListener eventListener) {
        if (eventListener == null) {
            throw new IllegalArgumentException("eventListener == null");
        }
        this.eventListeners.add(eventListener);
    }

    public ArrayList<SwingerEventListener> getEventListeners() {
        return this.eventListeners;
    }

    public boolean isHover() {
        return this.hover;
    }
}

