/*
 * Decompiled with CFR 0.152.
 */
package net.wytrem.wylog;

import java.text.SimpleDateFormat;
import net.wytrem.wylog.AbstractLogger;
import net.wytrem.wylog.ILogHandler;
import net.wytrem.wylog.LogLevel;
import net.wytrem.wylog.LoggerFactory;

public class BasicLogger
extends AbstractLogger {
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected String loggerName;

    protected BasicLogger(String name) {
        this.loggerName = name;
    }

    public void log(LogLevel level, String msg, Object ... args) {
        if (level.getIntLevel() < LoggerFactory.minLogLevel) {
            return;
        }
        String format = this.formatMessage(level, String.format(msg, args));
        this.broadcastLog(level, format);
    }

    private void broadcastLog(LogLevel level, String format) {
        for (ILogHandler handler : LoggerFactory.sharedHandlers) {
            handler.broadcastLog(level, format);
        }
    }

    public void log(LogLevel level, String msg, Throwable th) {
        if (level.getIntLevel() < LoggerFactory.minLogLevel) {
            return;
        }
        this.log(level, msg, new Object[0]);
        for (ILogHandler handler : LoggerFactory.sharedHandlers) {
            handler.broadcastThrowable(level, th);
        }
    }

    public String formatMessage(LogLevel level, String msg) {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(dateFormatter.format(System.currentTimeMillis())).append("] ");
        builder.append("[").append(level.name()).append("] ");
        builder.append("[").append(this.loggerName).append("] ");
        builder.append(msg);
        return builder.toString();
    }
}

