/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.minecraft;

import fr.theshark34.openlauncherlib.minecraft.GameTweak;
import fr.theshark34.openlauncherlib.minecraft.GameType;
import fr.theshark34.openlauncherlib.minecraft.GameVersion;
import fr.theshark34.openlauncherlib.minecraft.util.GameDirGenerator;
import fr.theshark34.openlauncherlib.util.LogUtil;
import java.io.File;
import java.util.ArrayList;

public class GameInfos {
    private String serverName;
    private File gameDir;
    private GameTweak[] tweaks;
    private GameVersion gameVersion;

    public GameInfos(String serverName, GameVersion gameVersion, GameTweak[] tweaks) {
        this(serverName, GameDirGenerator.createGameDir(serverName), gameVersion, tweaks);
    }

    public GameInfos(String serverName, File gameDir, GameVersion gameVersion, GameTweak[] tweaks) {
        this.serverName = serverName;
        this.gameDir = gameDir;
        this.gameVersion = gameVersion;
        this.tweaks = tweaks;
        if (tweaks != null) {
            boolean forge = false;
            boolean shaderOrOptifine = false;
            if (gameVersion.getGameType() == GameType.V1_13_HIGHER_FORGE) {
                if (tweaks.length == 1 && tweaks[0] == GameTweak.FORGE) {
                    tweaks = new GameTweak[]{};
                } else if (tweaks.length != 0) {
                    LogUtil.info("tweak-deprec");
                }
            }
            for (GameTweak tweak : tweaks) {
                if (tweak.equals(GameTweak.FORGE)) {
                    if (gameVersion.getGameType() == GameType.V1_5_2_LOWER) {
                        LogUtil.info("forge-old");
                    }
                    forge = true;
                    continue;
                }
                if (tweak != GameTweak.OPTIFINE && tweak != GameTweak.SHADER) continue;
                shaderOrOptifine = true;
            }
            if (tweaks.length > 0 && gameVersion.getGameType() == GameType.V1_5_2_LOWER) {
                LogUtil.info("old-tweaking");
            }
            if (shaderOrOptifine && forge) {
                LogUtil.info("forge-optifine");
                ArrayList<GameTweak> tweakList = new ArrayList<GameTweak>();
                for (GameTweak tweak : tweaks) {
                    if (tweak == GameTweak.OPTIFINE || tweak == GameTweak.SHADER) continue;
                    tweakList.add(tweak);
                }
                this.tweaks = tweakList.toArray(new GameTweak[tweakList.size()]);
            }
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public File getGameDir() {
        return this.gameDir;
    }

    public GameVersion getGameVersion() {
        return this.gameVersion;
    }

    public GameTweak[] getGameTweaks() {
        return this.tweaks;
    }

    public boolean hasGameTweak(GameTweak tweak) {
        for (GameTweak gameTweak : this.tweaks) {
            if (!gameTweak.equals(tweak)) continue;
            return true;
        }
        return false;
    }
}

