/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.minecraft;

import fr.theshark34.openlauncherlib.JavaUtil;
import fr.theshark34.openlauncherlib.LaunchException;
import fr.theshark34.openlauncherlib.external.ClasspathConstructor;
import fr.theshark34.openlauncherlib.external.ExternalLaunchProfile;
import fr.theshark34.openlauncherlib.internal.InternalLaunchProfile;
import fr.theshark34.openlauncherlib.minecraft.AuthInfos;
import fr.theshark34.openlauncherlib.minecraft.FolderException;
import fr.theshark34.openlauncherlib.minecraft.GameFolder;
import fr.theshark34.openlauncherlib.minecraft.GameInfos;
import fr.theshark34.openlauncherlib.minecraft.GameTweak;
import fr.theshark34.openlauncherlib.util.LogUtil;
import fr.theshark34.openlauncherlib.util.explorer.Explorer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MinecraftLauncher {
    @Deprecated
    public static InternalLaunchProfile createInternalProfile(GameInfos infos, GameFolder folder, AuthInfos authInfos) throws LaunchException {
        LogUtil.info("mc-int", infos.getGameVersion().getName());
        LogUtil.info("mc-check", infos.getGameDir().getAbsolutePath());
        MinecraftLauncher.checkFolder(folder, infos.getGameDir());
        LogUtil.info("mc-cp");
        List<File> libs = Explorer.dir(infos.getGameDir()).sub(folder.getLibsFolder()).allRecursive().files().match("^(.*\\.((jar)$))*$").get();
        libs.add(Explorer.dir(infos.getGameDir()).get(folder.getMainJar()));
        ArrayList<String> arguments = infos.getGameVersion().getGameType().getLaunchArgs(infos, folder, authInfos);
        if (infos.getGameTweaks() != null) {
            for (GameTweak tweak : infos.getGameTweaks()) {
                arguments.add("--tweakClass");
                arguments.add(tweak.getTweakClass(infos));
            }
        }
        String mainClass = infos.getGameTweaks() == null || infos.getGameTweaks().length == 0 ? infos.getGameVersion().getGameType().getMainClass(infos) : "net.minecraft.launchwrapper.Launch";
        String[] args = arguments.toArray(new String[arguments.size()]);
        InternalLaunchProfile profile = new InternalLaunchProfile(mainClass, args);
        profile.setClasspath(libs);
        System.setProperty("fml.ignoreInvalidMinecraftCertificates", "true");
        LogUtil.info("nat");
        try {
            JavaUtil.setLibraryPath(new File(infos.getGameDir(), folder.getNativesFolder()).getAbsolutePath());
        }
        catch (Exception e) {
            throw new LaunchException("Can't register the natives", e);
        }
        LogUtil.info("done");
        return profile;
    }

    public static ExternalLaunchProfile createExternalProfile(GameInfos infos, GameFolder folder, AuthInfos authInfos) throws LaunchException {
        LogUtil.info("mc-ext", infos.getGameVersion().getName());
        LogUtil.info("mc-check", infos.getGameDir().getAbsolutePath());
        if (authInfos == null) {
            throw new IllegalArgumentException("authInfos == null");
        }
        MinecraftLauncher.checkFolder(folder, infos.getGameDir());
        LogUtil.info("mc-cp");
        ClasspathConstructor constructor = new ClasspathConstructor();
        constructor.add(Explorer.dir(infos.getGameDir()).sub(folder.getLibsFolder()).allRecursive().files().match("^(.*\\.((jar)$))*$").get());
        constructor.add(Explorer.dir(infos.getGameDir()).get(folder.getMainJar()));
        String mainClass = infos.getGameTweaks() == null || infos.getGameTweaks().length == 0 ? infos.getGameVersion().getGameType().getMainClass(infos) : "net.minecraft.launchwrapper.Launch";
        String classpath = constructor.make();
        ArrayList<String> args = infos.getGameVersion().getGameType().getLaunchArgs(infos, folder, authInfos);
        ArrayList<String> vmArgs = new ArrayList<String>();
        vmArgs.add("-Djava.library.path=" + Explorer.dir(infos.getGameDir()).sub(folder.getNativesFolder()).get().getAbsolutePath());
        vmArgs.add("-Dfml.ignoreInvalidMinecraftCertificates=true");
        vmArgs.add("-Dfml.ignorePatchDiscrepancies=true");
        if (infos.getGameTweaks() != null) {
            for (GameTweak tweak : infos.getGameTweaks()) {
                args.add("--tweakClass");
                args.add(tweak.getTweakClass(infos));
            }
        }
        ExternalLaunchProfile profile = new ExternalLaunchProfile(mainClass, classpath, vmArgs, args, true, infos.getServerName(), infos.getGameDir());
        LogUtil.info("done");
        return profile;
    }

    public static void checkFolder(GameFolder folder, File directory) throws FolderException {
        File assetsFolder = new File(directory, folder.getAssetsFolder());
        File libsFolder = new File(directory, folder.getLibsFolder());
        File nativesFolder = new File(directory, folder.getNativesFolder());
        File minecraftJar = new File(directory, folder.getMainJar());
        if (!assetsFolder.exists() || assetsFolder.listFiles() == null) {
            throw new FolderException("Missing/Empty assets folder (" + assetsFolder.getAbsolutePath() + ")");
        }
        if (!libsFolder.exists() || libsFolder.listFiles() == null) {
            throw new FolderException("Missing/Empty libraries folder (" + libsFolder.getAbsolutePath() + ")");
        }
        if (!nativesFolder.exists() || nativesFolder.listFiles() == null) {
            throw new FolderException("Missing/Empty natives folder (" + nativesFolder.getAbsolutePath() + ")");
        }
        if (!minecraftJar.exists()) {
            throw new FolderException("Missing main jar (" + minecraftJar.getAbsolutePath() + ")");
        }
    }
}

