/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.util.ramselector;

import fr.theshark34.openlauncherlib.util.CrashReporter;
import fr.theshark34.openlauncherlib.util.LogUtil;
import fr.theshark34.openlauncherlib.util.ramselector.AbstractOptionFrame;
import fr.theshark34.openlauncherlib.util.ramselector.OptionFrame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.swing.JFrame;

public class RamSelector {
    public static final String[] RAM_ARRAY = new String[]{"1Go", "2Go", "3Go", "4Go", "5Go", "6Go", "7Go", "8Go", "9Go", "10Go"};
    private File file;
    private Class<? extends AbstractOptionFrame> frameClass = OptionFrame.class;
    private AbstractOptionFrame frame;

    public RamSelector(File file) {
        this.file = file;
    }

    public JFrame display() {
        if (this.frame == null) {
            try {
                Constructor<?>[] contructors = this.frameClass.getDeclaredConstructors();
                Constructor<?> constructor = null;
                for (Constructor<?> c : contructors) {
                    if (c.getParameterTypes().length != 1 || c.getParameterTypes()[0] != RamSelector.class) continue;
                    constructor = c;
                }
                if (constructor == null) {
                    throw new IllegalStateException("Can't load the OptionFrame class, it needs to have a constructor with just a RamSelector as argument.");
                }
                this.frame = (AbstractOptionFrame)constructor.newInstance(this);
                this.frame.setSelectedIndex(this.readRam());
            }
            catch (Exception e) {
                System.err.println("[OpenLauncherLib] Can't display the Ram Selector !");
                System.err.println(CrashReporter.makeCrashReport("OpenLauncherLib Ram Selector", e));
                return null;
            }
        }
        this.frame.setVisible(true);
        return this.frame;
    }

    public String[] getRamArguments() {
        int maxRam = Integer.parseInt(this.frame == null ? RAM_ARRAY[this.readRam()].replace("Go", "") : RAM_ARRAY[this.frame.getSelectedIndex()].replace("Go", "")) * 1024;
        int minRam = maxRam - 512;
        return new String[]{"-Xms" + minRam + "M", "-Xmx" + maxRam + "M"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readRam() {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.file));
            String ramText = br.readLine();
            if (ramText != null) {
                int n = Integer.parseInt(ramText);
                return n;
            }
            LogUtil.err("warn", "ram-empty");
        }
        catch (IOException e) {
            System.err.println("[OpenLauncherLib] WARNING: Can't read ram : " + e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    System.err.println("[OpenLauncherLib] WARNING: Can't close the file : " + e);
                }
            }
        }
        return 0;
    }

    public void save() {
        if (this.frame == null) {
            return;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(this.file));
            bw.write(String.valueOf(this.frame.getSelectedIndex()));
        }
        catch (IOException e) {
            System.err.println("[OpenLauncherLib] WARNING: Can't save ram : " + e);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    System.err.println("[OpenLauncherLib] WARNING: Can't close the file : " + e);
                }
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Class<? extends JFrame> getFrameClass() {
        return this.frameClass;
    }

    public void setFrameClass(Class<? extends AbstractOptionFrame> frameClass) {
        this.frameClass = frameClass;
    }
}

