/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.supdate.files;

import fr.theshark34.supdate.BarAPI;
import fr.theshark34.supdate.SUpdate;
import fr.theshark34.supdate.application.Application;
import fr.theshark34.supdate.application.event.fileaction.FileActionDownloadEvent;
import fr.theshark34.supdate.application.event.fileaction.FileActionEvent;
import fr.theshark34.supdate.application.event.fileaction.FileActionRenameEvent;
import fr.theshark34.supdate.exception.FileNoPermissionException;
import fr.theshark34.supdate.files.DownloadTask;
import fr.theshark34.supdate.files.FileAction;
import java.io.File;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class FileManager {
    private SUpdate sUpdate;
    private ExecutorService pool = Executors.newFixedThreadPool(10);

    public FileManager(SUpdate sUpdate) {
        this.sUpdate = sUpdate;
    }

    public void download(URL fileUrl, File outputFile) {
        this.pool.submit(new DownloadTask(fileUrl, outputFile));
        for (Application app : this.sUpdate.getApplicationManager().getApplications()) {
            app.onFileAction(new FileActionDownloadEvent(this.sUpdate, outputFile, fileUrl));
        }
    }

    public void tryToRename(File file, File dest) {
        file.renameTo(dest);
        for (Application app : this.sUpdate.getApplicationManager().getApplications()) {
            app.onFileAction(new FileActionRenameEvent(this.sUpdate, file, dest));
        }
    }

    public void rename(File file, File dest) throws FileNoPermissionException {
        if (!file.renameTo(dest)) {
            throw new FileNoPermissionException(file);
        }
        for (Application app : this.sUpdate.getApplicationManager().getApplications()) {
            app.onFileAction(new FileActionRenameEvent(this.sUpdate, file, dest));
        }
    }

    public void tryToDelete(File file) {
        if (!file.delete()) {
            file.deleteOnExit();
        }
        for (Application app : this.sUpdate.getApplicationManager().getApplications()) {
            app.onFileAction(new FileActionEvent(this.sUpdate, FileAction.DELETE, file));
        }
    }

    public void delete(File file) throws FileNoPermissionException {
        if (!file.delete()) {
            throw new FileNoPermissionException(file);
        }
        for (Application app : this.sUpdate.getApplicationManager().getApplications()) {
            app.onFileAction(new FileActionEvent(this.sUpdate, FileAction.DELETE, file));
        }
    }

    public void stop() {
        this.pool.shutdown();
        try {
            this.pool.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SUpdate.logger.info("Total downloaded bytes: %d", BarAPI.getNumberOfTotalDownloadedBytes());
    }
}

